/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import com.navercorp.pinpoint.thrift.dto.TAgentStatBatch;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectJob
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DataSender dataSender;
    private final String agentId;
    private final long agentStartTimestamp;
    private final AgentStatMetricCollector<TAgentStat> agentStatCollector;
    private final int numCollectionsPerBatch;
    private int collectCount = 0;
    private long prevCollectionTimestamp = System.currentTimeMillis();
    private List<TAgentStat> agentStats;

    public CollectJob(DataSender dataSender, String agentId, long agentStartTimestamp, AgentStatMetricCollector<TAgentStat> agentStatCollector, int numCollectionsPerBatch) {
        if (dataSender == null) {
            throw new NullPointerException("dataSender must not be null");
        }
        this.dataSender = dataSender;
        this.agentId = agentId;
        this.agentStartTimestamp = agentStartTimestamp;
        this.agentStatCollector = agentStatCollector;
        this.numCollectionsPerBatch = numCollectionsPerBatch;
        this.agentStats = new ArrayList<TAgentStat>(numCollectionsPerBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long currentCollectionTimestamp = System.currentTimeMillis();
        long collectInterval = currentCollectionTimestamp - this.prevCollectionTimestamp;
        try {
            TAgentStat agentStat = this.agentStatCollector.collect();
            agentStat.setTimestamp(currentCollectionTimestamp);
            agentStat.setCollectInterval(collectInterval);
            this.agentStats.add(agentStat);
            if (++this.collectCount >= this.numCollectionsPerBatch) {
                this.sendAgentStats();
                this.collectCount = 0;
            }
        }
        catch (Exception ex) {
            this.logger.warn("AgentStat collect failed. Caused:{}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            this.prevCollectionTimestamp = currentCollectionTimestamp;
        }
    }

    private void sendAgentStats() {
        TAgentStatBatch agentStatBatch = new TAgentStatBatch();
        agentStatBatch.setAgentId(this.agentId);
        agentStatBatch.setStartTimestamp(this.agentStartTimestamp);
        agentStatBatch.setAgentStats(this.agentStats);
        this.agentStats = new ArrayList<TAgentStat>(this.numCollectionsPerBatch);
        this.logger.trace("collect agentStat:{}", (Object)agentStatBatch);
        this.dataSender.send(agentStatBatch);
    }
}

