/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.buffer.AutomaticBuffer;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.TransactionIdUtils;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import java.nio.ByteBuffer;

public class DefaultTransactionIdEncoder
implements TransactionIdEncoder {
    private static final byte VERSION = 0;
    private final String agentId;
    private final long agentStartTime;
    private final byte[] agentIdCache;
    private final byte[] agentIdAndStartTimeCache;

    @Inject
    public DefaultTransactionIdEncoder(@AgentId String agentId, @AgentStartTime long agentStartTime) {
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTime = agentStartTime;
        this.agentIdCache = this.newCache(null);
        this.agentIdAndStartTimeCache = this.newCache(null, agentStartTime);
    }

    private byte[] newCache(String agentId, long agentStartTime) {
        int agentStartTimeSize = BytesUtils.computeVar64Size((long)agentStartTime);
        int agentIdSize = StringUtils.getLength((String)agentId);
        AutomaticBuffer buffer = new AutomaticBuffer(6 + agentIdSize + agentStartTimeSize);
        buffer.putByte((byte)0);
        buffer.putPrefixedString(agentId);
        buffer.putVLong(agentStartTime);
        return buffer.copyBuffer();
    }

    private byte[] newCache(String agentId) {
        int agentIdSize = StringUtils.getLength((String)agentId);
        AutomaticBuffer buffer = new AutomaticBuffer(6 + agentIdSize);
        buffer.putByte((byte)0);
        buffer.putPrefixedString(agentId);
        return buffer.copyBuffer();
    }

    private byte[] encode(String agentId, long agentStartTime, long transactionSequence) {
        return TransactionIdUtils.formatBytes((String)agentId, (long)agentStartTime, (long)transactionSequence);
    }

    private byte[] encodeAgentIdAndTransactionSequence(byte[] agentIdCache, long agentStartTime, long transactionSequence) {
        int agentStartTimeSize = BytesUtils.computeVar64Size((long)agentStartTime);
        int transactionSequenceSize = BytesUtils.computeVar64Size((long)transactionSequence);
        int prefixLength = agentIdCache.length;
        byte[] transactionId = new byte[prefixLength + agentStartTimeSize + transactionSequenceSize];
        System.arraycopy(agentIdCache, 0, transactionId, 0, prefixLength);
        BytesUtils.writeVar64((long)agentStartTime, (byte[])transactionId, (int)prefixLength);
        BytesUtils.writeVar64((long)transactionSequence, (byte[])transactionId, (int)(prefixLength + agentStartTimeSize));
        return transactionId;
    }

    private byte[] encodeTransactionSequence(byte[] agentIdAndStartTimeCache, long transactionSequence) {
        int transactionSequenceSize = BytesUtils.computeVar64Size((long)transactionSequence);
        int prefixLength = agentIdAndStartTimeCache.length;
        byte[] transactionId = new byte[prefixLength + transactionSequenceSize];
        System.arraycopy(agentIdAndStartTimeCache, 0, transactionId, 0, prefixLength);
        BytesUtils.writeVar64((long)transactionSequence, (byte[])transactionId, (int)prefixLength);
        return transactionId;
    }

    private byte[] encode(long transactionSequence) {
        byte[] encode = this.encodeTransactionSequence(this.agentIdAndStartTimeCache, transactionSequence);
        return encode;
    }

    private byte[] encode(long agentStartTime, long transactionSequence) {
        byte[] encode = this.encodeAgentIdAndTransactionSequence(this.agentIdCache, agentStartTime, transactionSequence);
        return encode;
    }

    private boolean isCompressedType(TraceId traceId) {
        return this.agentId.equals(traceId.getAgentId());
    }

    @Override
    public ByteBuffer encodeTransactionId(TraceId traceId) {
        if (traceId == null) {
            throw new NullPointerException("traceId must not be null");
        }
        return ByteBuffer.wrap(this.encodeTransaction0(traceId));
    }

    private byte[] encodeTransaction0(TraceId traceId) {
        if (this.isCompressedType(traceId)) {
            long transactionSequence = traceId.getTransactionSequence();
            if (this.agentStartTime == traceId.getAgentStartTime()) {
                return this.encode(traceId.getTransactionSequence());
            }
            return this.encode(traceId.getAgentStartTime(), transactionSequence);
        }
        return this.encode(traceId.getAgentId(), traceId.getAgentStartTime(), traceId.getTransactionSequence());
    }
}

