/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.NameSpaceChecker;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class DefaultNameSpaceChecker<T>
implements NameSpaceChecker<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final RequestAdaptor<T> requestAdaptor;
    private final String applicationNamespace;

    public DefaultNameSpaceChecker(RequestAdaptor<T> requestAdaptor, String applicationNamespace) {
        this.requestAdaptor = Assert.requireNonNull(requestAdaptor, "requestAdaptor must not be null");
        if (StringUtils.isEmpty(applicationNamespace)) {
            throw new IllegalArgumentException("applicationNamespace must not be empty");
        }
        this.applicationNamespace = applicationNamespace;
    }

    @Override
    public boolean checkNamespace(T request) {
        String parentApplicationNamespace = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_NAMESPACE.toString());
        if (parentApplicationNamespace == null) {
            return true;
        }
        if (this.applicationNamespace.equals(parentApplicationNamespace)) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Collision namespace. applicationNamespace={}, parentApplicationNamespace={}", (Object)this.applicationNamespace, (Object)parentApplicationNamespace);
        }
        return false;
    }
}

