/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v3.interceptor;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.AttachmentFactory;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpPluginConfig;
import com.navercorp.pinpoint.plugin.okhttp.v3.OkHttpClientCookieExtractor;
import com.navercorp.pinpoint.plugin.okhttp.v3.OkHttpClientRequestAdaptor;
import com.navercorp.pinpoint.plugin.okhttp.v3.UserRequestGetter;
import com.navercorp.pinpoint.plugin.okhttp.v3.UserResponseGetter;
import okhttp3.Request;

public class HttpEngineSendRequestMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final InterceptorScope interceptorScope;
    private final ClientRequestRecorder<Request> clientRequestRecorder;
    private final CookieRecorder<Request> cookieRecorder;

    public HttpEngineSendRequestMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
        OkHttpPluginConfig config = new OkHttpPluginConfig(traceContext.getProfilerConfig());
        OkHttpClientRequestAdaptor clientRequestAdaptor = new OkHttpClientRequestAdaptor();
        this.clientRequestRecorder = new ClientRequestRecorder(config.isParam(), (ClientRequestAdaptor)clientRequestAdaptor);
        OkHttpClientCookieExtractor cookieExtractor = new OkHttpClientCookieExtractor();
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)config.getHttpDumpConfig(), (CookieExtractor)cookieExtractor);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!this.validate(target)) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        try {
            final TraceId nextId = trace.getTraceId().getNextTraceId();
            recorder.recordNextSpanId(nextId.getSpanId());
            recorder.recordServiceType(OkHttpConstants.OK_HTTP_CLIENT);
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            if (invocation != null) {
                invocation.getOrCreateAttachment(new AttachmentFactory(){

                    public Object createAttachment() {
                        return nextId;
                    }
                });
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private boolean validate(Object target) {
        if (!(target instanceof UserRequestGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)"userRequest");
            }
            return false;
        }
        if (!(target instanceof UserResponseGetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)"userResponse");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!this.validate(target)) {
            return;
        }
        try {
            Request request;
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (attachment != null) {
                invocation.removeAttachment();
            }
            if ((request = ((UserRequestGetter)target)._$PINPOINT$_getUserRequest()) != null) {
                this.clientRequestRecorder.record(recorder, (Object)request, throwable);
                this.cookieRecorder.record(recorder, (Object)request, throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

