/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc.interceptor.client;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.plugin.grpc.GrpcConstants;
import com.navercorp.pinpoint.plugin.grpc.field.accessor.MethodNameAccessor;
import com.navercorp.pinpoint.plugin.grpc.field.accessor.RemoteAddressAccessor;
import com.navercorp.pinpoint.plugin.grpc.interceptor.client.GrpcClientHeaderAdaptor;
import io.grpc.Metadata;

public class ClientCallStartInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final RequestTraceWriter requestTraceWriter;

    public ClientCallStartInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        GrpcClientHeaderAdaptor grpcClientHeaderAdaptor = new GrpcClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)grpcClientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (ArrayUtils.getLength((Object[])args) != 2) {
            return;
        }
        if (!(args[1] instanceof Metadata)) {
            return;
        }
        Metadata metadata = (Metadata)args[1];
        if (!trace.canSampled()) {
            this.requestTraceWriter.write((Object)metadata);
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordApi(this.descriptor);
        recorder.recordServiceType(GrpcConstants.SERVICE_TYPE);
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        String remoteAddress = ClientCallStartInterceptor.getEndPoint(target);
        recorder.recordEndPoint(remoteAddress);
        recorder.recordDestinationId(remoteAddress);
        String methodName = this.getMethodName(target);
        recorder.recordAttribute(AnnotationKey.HTTP_URL, this.combineAddressAndMethodName(remoteAddress, methodName));
        this.requestTraceWriter.write((Object)metadata, nextId, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String combineAddressAndMethodName(String remoteAddress, String methodName) {
        Assert.requireNonNull((Object)remoteAddress, (String)"remoteAddress must not be null");
        Assert.requireNonNull((Object)methodName, (String)"methodName must not be null");
        if (remoteAddress.startsWith("http")) {
            return remoteAddress + "/" + methodName;
        }
        return "http://" + remoteAddress + "/" + methodName;
    }

    private String getMethodName(Object target) {
        String methodName;
        if (target instanceof MethodNameAccessor && (methodName = ((MethodNameAccessor)target)._$PINPOINT$_getMethodName()) != null) {
            return methodName;
        }
        return "UnknownMethod";
    }

    public static String getEndPoint(Object target) {
        String remoteAddress;
        if (target instanceof RemoteAddressAccessor && (remoteAddress = ((RemoteAddressAccessor)target)._$PINPOINT$_getRemoteAddress()) != null) {
            return remoteAddress;
        }
        return "Unknown";
    }
}

