/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class ConfigurationXMLReader
implements XMLReader {
    protected static final String NS_URI = "";
    private static final String DEFAULT_ROOT_NAME = "config";
    private static final Attributes EMPTY_ATTRS = new AttributesImpl();
    private ContentHandler contentHandler;
    private SAXException exception;
    private String rootName;

    protected ConfigurationXMLReader() {
        this.setRootName(DEFAULT_ROOT_NAME);
    }

    public void parse(String string) throws IOException, SAXException {
        this.parseConfiguration();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.parseConfiguration();
    }

    public boolean getFeature(String string) {
        return false;
    }

    public void setFeature(String string, boolean bl) {
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public Object getProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) {
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String string) {
        this.rootName = string;
    }

    protected void fireElementStart(String string, Attributes attributes) {
        if (this.getException() == null) {
            try {
                Attributes attributes2 = attributes == null ? EMPTY_ATTRS : attributes;
                this.getContentHandler().startElement(NS_URI, string, string, attributes2);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
            }
        }
    }

    protected void fireElementEnd(String string) {
        if (this.getException() == null) {
            try {
                this.getContentHandler().endElement(NS_URI, string, string);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
            }
        }
    }

    protected void fireCharacters(String string) {
        if (this.getException() == null) {
            try {
                char[] cArray = string.toCharArray();
                this.getContentHandler().characters(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
            }
        }
    }

    public SAXException getException() {
        return this.exception;
    }

    protected void parseConfiguration() throws IOException, SAXException {
        if (this.getParsedConfiguration() == null) {
            throw new IOException("No configuration specified!");
        }
        if (this.getContentHandler() != null) {
            this.exception = null;
            this.getContentHandler().startDocument();
            this.processKeys();
            if (this.getException() != null) {
                throw this.getException();
            }
            this.getContentHandler().endDocument();
        }
    }

    public abstract Configuration getParsedConfiguration();

    protected abstract void processKeys() throws IOException, SAXException;
}

