/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceLogDelegateStorage
implements Storage {
    private final Logger logger = LoggerFactory.getLogger((String)DefaultTrace.class.getName());
    private final Storage delegate;

    public TraceLogDelegateStorage(Storage delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        this.delegate = delegate;
    }

    @Override
    public void store(SpanEvent spanEvent) {
        if (this.logger.isTraceEnabled()) {
            Thread th = Thread.currentThread();
            this.logger.trace("[DefaultTrace] Write {} thread{id={}, name={}}", new Object[]{spanEvent, th.getId(), th.getName()});
        }
        this.delegate.store(spanEvent);
    }

    @Override
    public void store(Span span) {
        if (this.logger.isTraceEnabled()) {
            Thread th = Thread.currentThread();
            this.logger.trace("[DefaultTrace] Write {} thread{id={}, name={}}", new Object[]{span, th.getId(), th.getName()});
        }
        this.delegate.store(span);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

