/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.thrift.ThriftPluginConfig;
import java.security.ProtectionDomain;
import java.util.List;

public class ThriftPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        boolean traceCommon;
        ThriftPluginConfig config = new ThriftPluginConfig(context.getConfig());
        boolean traceClient = config.traceThriftClient();
        boolean traceClientAsync = config.traceThriftClientAsync();
        boolean traceProcessor = config.traceThriftProcessor();
        boolean traceProcessorAsync = config.traceThriftProcessorAsync();
        boolean bl = traceCommon = traceClient || traceProcessor;
        if (traceClient) {
            this.addInterceptorsForSynchronousClients(config);
            this.addTHttpClientEditor();
            if (traceClientAsync) {
                this.addInterceptorsForAsynchronousClients();
            }
        }
        if (traceProcessor) {
            this.addInterceptorsForSynchronousProcessors();
            if (traceProcessorAsync) {
                this.addInterceptorsForAsynchronousProcessors();
            }
        }
        if (traceCommon) {
            this.addInterceptorsForRetrievingSocketAddresses();
            this.addTProtocolEditors(config);
        }
    }

    private void addInterceptorsForSynchronousClients(ThriftPluginConfig config) {
        this.addTServiceClientEditor(config);
    }

    private void addTServiceClientEditor(ThriftPluginConfig config) {
        final boolean traceServiceArgs = config.traceThriftServiceArgs();
        final boolean traceServiceResult = config.traceThriftServiceResult();
        String targetClassName = "org.apache.thrift.TServiceClient";
        this.transformTemplate.transform("org.apache.thrift.TServiceClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod receiveBase;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod sendBase = target.getDeclaredMethod("sendBase", new String[]{"java.lang.String", "org.apache.thrift.TBase"});
                if (sendBase != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.TServiceClientSendBaseInterceptor";
                    InterceptorScope thriftClientScope = instrumentor.getInterceptorScope("ThriftClientScope");
                    sendBase.addScopedInterceptor(interceptor, VarArgs.va((Object[])new Object[]{traceServiceArgs}), thriftClientScope, ExecutionPolicy.BOUNDARY);
                }
                if ((receiveBase = target.getDeclaredMethod("receiveBase", new String[]{"org.apache.thrift.TBase", "java.lang.String"})) != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.TServiceClientReceiveBaseInterceptor";
                    receiveBase.addInterceptor(interceptor, VarArgs.va((Object[])new Object[]{traceServiceResult}));
                }
                return target.toBytecode();
            }
        });
    }

    private void addInterceptorsForAsynchronousClients() {
        this.addTAsyncClientManagerEditor();
        this.addTAsyncMethodCallEditor();
    }

    private void addTAsyncClientManagerEditor() {
        String targetClassName = "org.apache.thrift.async.TAsyncClientManager";
        this.transformTemplate.transform("org.apache.thrift.async.TAsyncClientManager", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod call = target.getDeclaredMethod("call", new String[]{"org.apache.thrift.async.TAsyncMethodCall"});
                if (call != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.async.TAsyncClientManagerCallInterceptor";
                    InterceptorScope thriftClientScope = instrumentor.getInterceptorScope("ThriftClientScope");
                    call.addScopedInterceptor(interceptor, thriftClientScope, ExecutionPolicy.BOUNDARY);
                }
                return target.toBytecode();
            }
        });
    }

    private void addTAsyncMethodCallEditor() {
        String targetClassName = "org.apache.thrift.async.TAsyncMethodCall";
        this.transformTemplate.transform("org.apache.thrift.async.TAsyncMethodCall", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod onError;
                InstrumentMethod cleanUpAndFireCallback;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketAddressFieldAccessor");
                target.addGetter("com.navercorp.pinpoint.plugin.thrift.field.getter.TNonblockingTransportFieldGetter", "transport");
                InstrumentMethod constructor = target.getConstructor(new String[]{"org.apache.thrift.async.TAsyncClient", "org.apache.thrift.protocol.TProtocolFactory", "org.apache.thrift.transport.TNonblockingTransport", "org.apache.thrift.async.AsyncMethodCallback", "boolean"});
                if (constructor != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.async.TAsyncMethodCallConstructInterceptor";
                    constructor.addInterceptor(interceptor);
                }
                if ((cleanUpAndFireCallback = target.getDeclaredMethod("cleanUpAndFireCallback", new String[]{"java.nio.channels.SelectionKey"})) != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.async.TAsyncMethodCallCleanUpAndFireCallbackInterceptor";
                    cleanUpAndFireCallback.addInterceptor(interceptor);
                }
                if ((onError = target.getDeclaredMethod("onError", new String[]{"java.lang.Exception"})) != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.client.async.TAsyncMethodCallOnErrorInterceptor";
                    onError.addInterceptor(interceptor);
                }
                return target.toBytecode();
            }
        });
    }

    private void addInterceptorsForSynchronousProcessors() {
        this.addTBaseProcessorEditor();
        this.addProcessFunctionEditor();
    }

    private void addTBaseProcessorEditor() {
        String targetClassName = "org.apache.thrift.TBaseProcessor";
        this.transformTemplate.transform("org.apache.thrift.TBaseProcessor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod process = target.getDeclaredMethod("process", new String[]{"org.apache.thrift.protocol.TProtocol", "org.apache.thrift.protocol.TProtocol"});
                if (process != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.server.TBaseProcessorProcessInterceptor";
                    InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                    process.addScopedInterceptor(interceptor, thriftServerScope, ExecutionPolicy.BOUNDARY);
                }
                return target.toBytecode();
            }
        });
    }

    private void addProcessFunctionEditor() {
        String targetClassName = "org.apache.thrift.ProcessFunction";
        this.transformTemplate.transform("org.apache.thrift.ProcessFunction", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor");
                InstrumentMethod process = target.getDeclaredMethod("process", new String[]{"int", "org.apache.thrift.protocol.TProtocol", "org.apache.thrift.protocol.TProtocol", "java.lang.Object"});
                if (process != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.server.ProcessFunctionProcessInterceptor";
                    InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                    process.addScopedInterceptor(interceptor, thriftServerScope, ExecutionPolicy.INTERNAL);
                }
                return target.toBytecode();
            }
        });
    }

    private void addInterceptorsForAsynchronousProcessors() {
        this.addTBaseAsyncProcessorEditor();
    }

    private void addTBaseAsyncProcessorEditor() {
        String targetClassName = "org.apache.thrift.TBaseAsyncProcessor";
        this.transformTemplate.transform("org.apache.thrift.TBaseAsyncProcessor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor");
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.AsyncMarkerFlagFieldAccessor");
                InstrumentMethod process = target.getDeclaredMethod("process", new String[]{"org.apache.thrift.server.AbstractNonblockingServer$AsyncFrameBuffer"});
                if (process != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.server.async.TBaseAsyncProcessorProcessInterceptor";
                    InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                    process.addScopedInterceptor(interceptor, thriftServerScope, ExecutionPolicy.BOUNDARY);
                }
                return target.toBytecode();
            }
        });
    }

    private void addTHttpClientEditor() {
        this.transformTemplate.transform("org.apache.thrift.transport.THttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.thrift.field.getter.UrlFieldGetter", "url_");
                return target.toBytecode();
            }
        });
    }

    private void addInterceptorsForRetrievingSocketAddresses() {
        this.addTTransportEditor("org.apache.thrift.transport.TSocket", "com.navercorp.pinpoint.plugin.thrift.interceptor.transport.TSocketConstructInterceptor", {"java.net.Socket"}, {"java.lang.String", "int", "int"});
        this.addTTransportEditor("org.apache.thrift.transport.TFramedTransport", "com.navercorp.pinpoint.plugin.thrift.interceptor.transport.wrapper.TFramedTransportConstructInterceptor", {"org.apache.thrift.transport.TTransport"}, {"org.apache.thrift.transport.TTransport", "int"});
        this.addTTransportEditor("org.apache.thrift.transport.TFastFramedTransport", "com.navercorp.pinpoint.plugin.thrift.interceptor.transport.wrapper.TFastFramedTransportConstructInterceptor", new String[][]{{"org.apache.thrift.transport.TTransport", "int", "int"}});
        this.addTTransportEditor("org.apache.thrift.transport.TSaslClientTransport", "com.navercorp.pinpoint.plugin.thrift.interceptor.transport.wrapper.TSaslTransportConstructInterceptor", {"org.apache.thrift.transport.TTransport"}, {"javax.security.sasl.SaslClient", "org.apache.thrift.transport.TTransport"});
        this.addTTransportEditor("org.apache.thrift.transport.TMemoryInputTransport");
        this.addTTransportEditor("org.apache.thrift.transport.TIOStreamTransport");
        this.addTNonblockingSocketEditor();
        this.addFrameBufferEditor();
    }

    private void addTTransportEditor(String tTransportFqcn) {
        String targetClassName = tTransportFqcn;
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor");
                return target.toBytecode();
            }
        });
    }

    private void addTTransportEditor(String tTransportClassName, final String tTransportInterceptorFqcn, final String[] ... parameterTypeGroups) {
        String targetClassName = tTransportClassName;
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor");
                for (String[] parameterTypeGroup : parameterTypeGroups) {
                    InstrumentMethod constructor = target.getConstructor(parameterTypeGroup);
                    if (constructor == null) continue;
                    constructor.addInterceptor(tTransportInterceptorFqcn);
                }
                return target.toBytecode();
            }
        });
    }

    private void addTNonblockingSocketEditor() {
        String targetClassName = "org.apache.thrift.transport.TNonblockingSocket";
        this.transformTemplate.transform("org.apache.thrift.transport.TNonblockingSocket", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor");
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketAddressFieldAccessor");
                InstrumentMethod constructor = target.getConstructor(new String[]{"java.nio.channels.SocketChannel", "int", "java.net.SocketAddress"});
                if (constructor != null) {
                    String interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.transport.TNonblockingSocketConstructInterceptor";
                    constructor.addInterceptor(interceptor);
                }
                return target.toBytecode();
            }
        });
    }

    private void addFrameBufferEditor() {
        String targetClassName = "org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer";
        this.transformTemplate.transform("org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod getInputTransport;
                String interceptor;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor");
                target.addGetter("com.navercorp.pinpoint.plugin.thrift.field.getter.TNonblockingTransportFieldGetter", "trans_");
                if (target.hasField("inTrans_")) {
                    target.addGetter("com.navercorp.pinpoint.plugin.thrift.field.getter.TTransportFieldGetter", "inTrans_");
                    InstrumentMethod constructor = target.getConstructor(new String[]{"org.apache.thrift.server.AbstractNonblockingServer", "org.apache.thrift.transport.TNonblockingTransport", "java.nio.channels.SelectionKey", "org.apache.thrift.server.AbstractNonblockingServer$AbstractSelectThread"});
                    if (constructor != null) {
                        interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.server.nonblocking.FrameBufferConstructInterceptor";
                        constructor.addInterceptor(interceptor);
                    }
                }
                if (target.hasMethod("getInputTransport", new String[]{"org.apache.thrift.transport.TTransport"}) && (getInputTransport = target.getDeclaredMethod("getInputTransport", new String[]{"org.apache.thrift.transport.TTransport"})) != null) {
                    interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.server.nonblocking.FrameBufferGetInputTransportInterceptor";
                    getInputTransport.addInterceptor(interceptor);
                }
                return target.toBytecode();
            }
        });
    }

    private void addTProtocolEditors(ThriftPluginConfig config) {
        this.addTProtocolInterceptors(config, "org.apache.thrift.protocol.TBinaryProtocol");
        this.addTProtocolInterceptors(config, "org.apache.thrift.protocol.TCompactProtocol");
        this.addTProtocolInterceptors(config, "org.apache.thrift.protocol.TJSONProtocol");
        this.addTProtocolDecoratorEditor();
    }

    private void addTProtocolInterceptors(ThriftPluginConfig config, String tProtocolClassName) {
        final boolean traceThriftClient = config.traceThriftClient();
        final boolean traceThriftProcessor = config.traceThriftProcessor();
        String targetClassName = tProtocolClassName;
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                String interceptor;
                InstrumentMethod writeFieldStop;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (traceThriftClient && (writeFieldStop = target.getDeclaredMethod("writeFieldStop", new String[0])) != null) {
                    interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.client.TProtocolWriteFieldStopInterceptor";
                    InterceptorScope thriftClientScope = instrumentor.getInterceptorScope("ThriftClientScope");
                    writeFieldStop.addScopedInterceptor(interceptor, thriftClientScope, ExecutionPolicy.INTERNAL);
                }
                if (traceThriftProcessor) {
                    InstrumentMethod readMessageEnd;
                    List readTTypes;
                    target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor");
                    InstrumentMethod readFieldBegin = target.getDeclaredMethod("readFieldBegin", new String[0]);
                    if (readFieldBegin != null) {
                        interceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server.TProtocolReadFieldBeginInterceptor";
                        InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                        readFieldBegin.addScopedInterceptor(interceptor, thriftServerScope, ExecutionPolicy.INTERNAL);
                    }
                    if ((readTTypes = target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"readBool", "readBinary", "readI16", "readI64"}))) != null) {
                        String tTypeCommonInterceptor = "com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server.TProtocolReadTTypeInterceptor";
                        InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                        for (InstrumentMethod readTType : readTTypes) {
                            if (readTType == null) continue;
                            readTType.addScopedInterceptor(tTypeCommonInterceptor, thriftServerScope, ExecutionPolicy.INTERNAL);
                        }
                    }
                    if ((readMessageEnd = target.getDeclaredMethod("readMessageEnd", new String[0])) != null) {
                        String interceptor2 = "com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server.TProtocolReadMessageEndInterceptor";
                        InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                        readMessageEnd.addScopedInterceptor(interceptor2, thriftServerScope, ExecutionPolicy.INTERNAL);
                    }
                    target.addField("com.navercorp.pinpoint.plugin.thrift.field.accessor.AsyncMarkerFlagFieldAccessor");
                    InstrumentMethod readMessageBegin = target.getDeclaredMethod("readMessageBegin", new String[0]);
                    if (readMessageBegin != null) {
                        String interceptor3 = "com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server.TProtocolReadMessageBeginInterceptor";
                        InterceptorScope thriftServerScope = instrumentor.getInterceptorScope("ThriftServerScope");
                        readMessageBegin.addScopedInterceptor(interceptor3, thriftServerScope, ExecutionPolicy.INTERNAL);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addTProtocolDecoratorEditor() {
        this.transformTemplate.transform("org.apache.thrift.protocol.TProtocolDecorator", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.thrift.field.getter.TProtocolFieldGetter", "concreteProtocol");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

