/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.header;

import com.navercorp.pinpoint.common.buffer.Buffer;
import com.navercorp.pinpoint.common.buffer.OffsetFixedBuffer;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.header.HeaderReader;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import com.navercorp.pinpoint.io.header.v1.HeaderV1;
import com.navercorp.pinpoint.io.header.v2.HeaderV2;
import java.util.HashMap;

public class ByteArrayHeaderReader
implements HeaderReader {
    private final Buffer buffer;

    public ByteArrayHeaderReader(byte[] bytes) {
        this(ByteArrayHeaderReader.checkBytes(bytes), 0, bytes.length);
    }

    public ByteArrayHeaderReader(byte[] bytes, int startOffset, int length) {
        ByteArrayHeaderReader.checkBytes(bytes);
        this.buffer = new OffsetFixedBuffer(bytes, startOffset, length);
    }

    private static byte[] checkBytes(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        return bytes;
    }

    @Override
    public Header readHeader() {
        byte signature = this.buffer.readByte();
        if (signature != -17) {
            throw new InvalidHeaderException("invalid signature :" + signature);
        }
        byte version = this.buffer.readByte();
        short type = this.buffer.readShort();
        if (version == 16) {
            return new HeaderV1(signature, version, type);
        }
        if (version == 32) {
            return new HeaderV2(signature, version, type);
        }
        throw new InvalidHeaderException(String.format("invalid Header : signature(0x%02X), version(0x%02X)", signature, version));
    }

    @Override
    public HeaderEntity readHeaderEntity(Header header) {
        byte version = header.getVersion();
        if (version == 16) {
            return HeaderEntity.EMPTY_HEADER_ENTITY;
        }
        if (version == 32) {
            return this.readHeaderEntity();
        }
        throw new InvalidHeaderException("invalid Header : " + header);
    }

    private HeaderEntity readHeaderEntity() {
        int headerEntitySize = this.buffer.readShort();
        if (headerEntitySize < 0 || headerEntitySize > 64) {
            throw new InvalidHeaderException("header entity count size is invalid. size : " + headerEntitySize);
        }
        if (headerEntitySize == 0) {
            return HeaderEntity.EMPTY_HEADER_ENTITY;
        }
        HashMap<String, String> headerEntity = new HashMap<String, String>(headerEntitySize);
        for (int i = 0; i < headerEntitySize; ++i) {
            String key = this.readString();
            String value = this.readString();
            headerEntity.put(key, value);
        }
        return new HeaderEntity(headerEntity);
    }

    private String readString() {
        short stringLength = this.buffer.readShort();
        if (!this.validCheck(stringLength)) {
            throw new InvalidHeaderException("string length is invalid in header data. length : " + stringLength);
        }
        this.buffer.setOffset(this.buffer.getOffset() - 2);
        return this.buffer.read2PrefixedString();
    }

    private boolean validCheck(short length) {
        return length <= 1024 && length != 0;
    }

    @Override
    public int getOffset() {
        return this.buffer.getOffset();
    }

    @Override
    public int getRemaining() {
        return this.buffer.remaining();
    }
}

