/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

public class TransactionId {
    private String agentId;
    private long agentStartTime;
    private long transactionSequence;

    public TransactionId(String agentId, long agentStartTime, long transactionSequence) {
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        this.agentId = agentId;
        this.agentStartTime = agentStartTime;
        this.transactionSequence = transactionSequence;
    }

    public TransactionId(long agentStartTime, long transactionSequence) {
        this.agentStartTime = agentStartTime;
        this.transactionSequence = transactionSequence;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public long getAgentStartTime() {
        return this.agentStartTime;
    }

    public long getTransactionSequence() {
        return this.transactionSequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionId that = (TransactionId)o;
        if (this.agentStartTime != that.agentStartTime) {
            return false;
        }
        if (this.transactionSequence != that.transactionSequence) {
            return false;
        }
        return this.agentId.equals(that.agentId);
    }

    public int hashCode() {
        int result = this.agentId.hashCode();
        result = 31 * result + (int)(this.agentStartTime ^ this.agentStartTime >>> 32);
        result = 31 * result + (int)(this.transactionSequence ^ this.transactionSequence >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionId{");
        sb.append("agentId='").append(this.agentId).append('\'');
        sb.append(", agentStartTime=").append(this.agentStartTime);
        sb.append(", transactionSequence=").append(this.transactionSequence);
        sb.append('}');
        return sb.toString();
    }
}

