/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.lang.reflect.Constructor;

final class MethodDescriptionUtils {
    private static final String EMPTY_ARRAY = "()";

    private MethodDescriptionUtils() {
    }

    public static String toJavaMethodDescriptor(String className, String methodName, String[] parameterType) {
        if (className == null) {
            throw new NullPointerException("className must not be null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName must not be null");
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(className);
        buffer.append('.');
        buffer.append(methodName);
        MethodDescriptionUtils.appendParameter(buffer, parameterType);
        return buffer.toString();
    }

    public static String toJavaMethodDescriptor(String apiMetaDataDescriptor) {
        if (apiMetaDataDescriptor == null) {
            return "";
        }
        int methodDescBegin = apiMetaDataDescriptor.indexOf(40);
        if (methodDescBegin == -1) {
            throw new IllegalArgumentException("invalid api descriptor=" + apiMetaDataDescriptor);
        }
        int methodDescEnd = apiMetaDataDescriptor.indexOf(41, methodDescBegin);
        if (methodDescEnd == -1) {
            throw new IllegalArgumentException("invalid api descriptor=" + apiMetaDataDescriptor);
        }
        int classNameEnd = apiMetaDataDescriptor.lastIndexOf(46, methodDescBegin);
        if (classNameEnd == -1) {
            throw new IllegalArgumentException("invalid api descriptor=" + apiMetaDataDescriptor);
        }
        String className = apiMetaDataDescriptor.substring(0, classNameEnd);
        String methodName = apiMetaDataDescriptor.substring(classNameEnd + 1, methodDescBegin);
        String methodDesc = apiMetaDataDescriptor.substring(methodDescBegin + 1, methodDescEnd);
        String[] parameterTypes = methodDesc.split(",");
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i];
            parameterTypes[i] = MethodDescriptionUtils.extractParameterClass(parameterType);
        }
        return MethodDescriptionUtils.toJavaMethodDescriptor(className, methodName, parameterTypes);
    }

    private static void appendParameter(StringBuilder buffer, String[] parameterType) {
        if (ArrayUtils.isEmpty((Object[])parameterType)) {
            buffer.append(EMPTY_ARRAY);
        } else {
            buffer.append('(');
            int end = parameterType.length - 1;
            for (int i = 0; i < parameterType.length; ++i) {
                buffer.append(parameterType[i]);
                if (i >= end) continue;
                buffer.append(", ");
            }
            buffer.append(')');
        }
    }

    private static String extractParameterClass(String parameterType) {
        int classEndIndex = (parameterType = MethodDescriptionUtils.safeTrim(parameterType)).indexOf(32);
        if (classEndIndex != -1) {
            return parameterType.substring(0, classEndIndex);
        }
        return parameterType;
    }

    private static String safeTrim(String parameterType) {
        if (StringUtils.isEmpty((String)parameterType)) {
            return parameterType;
        }
        return parameterType.trim();
    }

    public static String getConstructorSimpleName(Constructor<?> constructor) {
        String name = constructor.getName();
        return MethodDescriptionUtils.getConstructorSimpleName(name);
    }

    static String getConstructorSimpleName(String name) {
        int startIndex = name.lastIndexOf(46);
        if (startIndex == -1) {
            return name;
        }
        return name.substring(startIndex + 1, name.length());
    }
}

