#!/bin/bash
HOST=$1
PORT=$2
USER=$3
PASSWORD=$4
HTTPS=$5
NAMESPACE=$6
# PASSWORD=qatest
# HOST=192.168.4.18
# PORT=32240
# USER=qa
# HTTPS=true
# NAMESPACE=tianyawei

DB_FILE=dump.sql

EXCLUDED_TABLES=(
clotho.JOB_EXECUTION_LOG
clotho.JOB_STATUS_TRACE_LOG
notify.JOB_EXECUTION_LOG
notify.JOB_STATUS_TRACE_LOG
xyqb.JOB_EXECUTION_LOG
xyqb.JOB_STATUS_TRACE_LOG
xyqb.channel
xyqb.t_phonenum
mall.jd_address
mall.jd_brand
mall.jd_product_sku_image
mall.jd_property
mall.jd_sku
mall.jd_sku_detail_image
mall.jd_sku_specs
mall.spu_image
mall.sale_product_detail
mall.product_nature_value_bak
mall.product_sku
mall.product_sku_image
mall.product_specification
mall.product_spu
)

IGNORED_TABLES_STRING=''
for TABLE in "${EXCLUDED_TABLES[@]}"
do :
   IGNORED_TABLES_STRING+=" --ignore-table=${TABLE}"
done

# echo "Dump structure"
# mysqldump --host=${HOST} --user=${USER} --password=${PASSWORD} --single-transaction --no-data ${DATABASE} > ${DB_FILE}

echo "Dump content"
echo "mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases --no-create-info ${IGNORED_TABLES_STRING} >> ${DB_FILE}"
mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases ${IGNORED_TABLES_STRING} >> ${DB_FILE}
echo "sed file"
if [[ $HTTPS = true ]];then
	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-base\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g" ${DB_FILE}
else
	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-base\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g; s#\https#http#g" ${DB_FILE}
fi

echo "mysql dump file"
mysql --host=${HOST} --${PORT}  --user=${USER} --password=${PASSWORD} < ${DB_FILE}

