/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.profiler.instrument.classloading.DefineClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReflectionDefineClass
implements DefineClass {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Method DEFINE_CLASS;

    ReflectionDefineClass() {
    }

    @Override
    public final Class<?> defineClass(ClassLoader classLoader, String name, byte[] bytes) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("define class:{} cl:{}", (Object)name, (Object)classLoader);
        }
        try {
            return (Class)DEFINE_CLASS.invoke((Object)classLoader, name, bytes, 0, bytes.length);
        }
        catch (IllegalAccessException e) {
            throw this.handleDefineClassFail(classLoader, name, e);
        }
        catch (InvocationTargetException e) {
            throw this.handleDefineClassFail(classLoader, name, e);
        }
    }

    private RuntimeException handleDefineClassFail(ClassLoader classLoader, String className, Exception e) {
        this.logger.warn("{} define fail cl:{} Caused by:{}", new Object[]{className, classLoader, e.getMessage(), e});
        return new RuntimeException(className + " define fail Caused by:" + e.getMessage(), e);
    }

    static {
        try {
            DEFINE_CLASS = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            DEFINE_CLASS.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot access ClassLoader.defineClass(String, byte[], int, int)", e);
        }
    }
}

