/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.instrument.ASMClassWriter;
import com.navercorp.pinpoint.profiler.instrument.ASMFieldNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodInsnNodeRemapper;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMClassNodeAdapter {
    private final InstrumentContext pluginContext;
    private final ClassLoader classLoader;
    private final ClassNode classNode;
    private final boolean skipCode;

    public static ASMClassNodeAdapter get(InstrumentContext pluginContext, ClassLoader classLoader, String classInternalName) {
        return ASMClassNodeAdapter.get(pluginContext, classLoader, classInternalName, false);
    }

    public static ASMClassNodeAdapter get(InstrumentContext pluginContext, ClassLoader classLoader, String classInternalName, boolean skipCode) {
        byte[] bytes;
        if (pluginContext == null) {
            throw new NullPointerException("pluginContext must not be null");
        }
        if (classInternalName == null) {
            throw new NullPointerException("classInternalName must not be null");
        }
        String classPath = classInternalName.concat(".class");
        InputStream in = pluginContext.getResourceAsStream(classLoader, classPath);
        if (in == null) {
            return null;
        }
        try {
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException ignore) {
            return null;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        if (skipCode) {
            classReader.accept((ClassVisitor)classNode, 1);
        } else {
            classReader.accept((ClassVisitor)classNode, 0);
        }
        return new ASMClassNodeAdapter(pluginContext, classLoader, classNode, skipCode);
    }

    public ASMClassNodeAdapter(InstrumentContext pluginContext, ClassLoader classLoader, ClassNode classNode) {
        this(pluginContext, classLoader, classNode, false);
    }

    public ASMClassNodeAdapter(InstrumentContext pluginContext, ClassLoader classLoader, ClassNode classNode, boolean skipCode) {
        this.pluginContext = pluginContext;
        this.classLoader = classLoader;
        this.classNode = classNode;
        this.skipCode = skipCode;
    }

    public String getInternalName() {
        return this.classNode.name;
    }

    public String getName() {
        return this.classNode.name == null ? null : JavaAssistUtils.jvmNameToJavaName(this.classNode.name);
    }

    public String getSuperClassInternalName() {
        return this.classNode.superName;
    }

    public String getSuperClassName() {
        return this.classNode.superName == null ? null : JavaAssistUtils.jvmNameToJavaName(this.classNode.superName);
    }

    public boolean isInterface() {
        return (this.classNode.access & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classNode.access & 0x2000) != 0;
    }

    public String[] getInterfaceNames() {
        List interfaces = this.classNode.interfaces;
        if (CollectionUtils.isEmpty((Collection)interfaces)) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : interfaces) {
            if (name == null) continue;
            list.add(JavaAssistUtils.jvmNameToJavaName(name));
        }
        return list.toArray(new String[0]);
    }

    public ASMMethodNodeAdapter getDeclaredMethod(String methodName, String desc) {
        if (this.skipCode) {
            throw new IllegalStateException("not supported operation, skipCode option is true.");
        }
        return this.findDeclaredMethod(methodName, desc);
    }

    public boolean hasDeclaredMethod(String methodName, String desc) {
        return this.findDeclaredMethod(methodName, desc) != null;
    }

    private ASMMethodNodeAdapter findDeclaredMethod(String methodName, String desc) {
        if (methodName == null) {
            return null;
        }
        List declaredMethods = this.classNode.methods;
        if (declaredMethods == null) {
            return null;
        }
        for (MethodNode methodNode : declaredMethods) {
            if (methodNode.name == null || !methodNode.name.equals(methodName) || desc != null && (methodNode.desc == null || !methodNode.desc.startsWith(desc))) continue;
            return new ASMMethodNodeAdapter(this.getInternalName(), methodNode);
        }
        return null;
    }

    public List<ASMMethodNodeAdapter> getDeclaredMethods() {
        if (this.skipCode) {
            throw new IllegalStateException("not supported operation, skipCode option is true.");
        }
        ArrayList<ASMMethodNodeAdapter> methodNodes = new ArrayList<ASMMethodNodeAdapter>();
        if (this.classNode.methods == null) {
            return methodNodes;
        }
        for (MethodNode methodNode : this.classNode.methods) {
            if (methodNode.name == null || methodNode.name.equals("<init>") || methodNode.name.equals("<clinit>")) continue;
            methodNodes.add(new ASMMethodNodeAdapter(this.getInternalName(), methodNode));
        }
        return methodNodes;
    }

    public boolean hasOutClass(String methodName, String desc) {
        if (methodName == null || this.classNode.outerClass == null || this.classNode.outerMethod == null || !this.classNode.outerMethod.equals(methodName)) {
            return false;
        }
        return desc == null || this.classNode.outerMethodDesc != null && this.classNode.outerMethodDesc.startsWith(desc);
    }

    public boolean hasMethod(String methodName, String desc) {
        ASMClassNodeAdapter classNode;
        if (this.hasDeclaredMethod(methodName, desc)) {
            return true;
        }
        if (this.classNode.superName != null && (classNode = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, this.classNode.superName, true)) != null) {
            return classNode.hasMethod(methodName, desc);
        }
        return false;
    }

    public ASMFieldNodeAdapter getField(String fieldName, String fieldDesc) {
        ASMFieldNodeAdapter fieldNode;
        ASMClassNodeAdapter classNodeAdapter;
        if (fieldName == null || this.classNode.fields == null) {
            return null;
        }
        List fields = this.classNode.fields;
        for (FieldNode fieldNode2 : fields) {
            if (fieldNode2.name == null || !fieldNode2.name.equals(fieldName) || fieldDesc != null && (fieldNode2.desc == null || !fieldNode2.desc.equals(fieldDesc))) continue;
            return new ASMFieldNodeAdapter(fieldNode2);
        }
        List interfaces = this.classNode.interfaces;
        if (interfaces != null && interfaces.size() > 0) {
            for (String interfaceClassName : interfaces) {
                ASMFieldNodeAdapter fieldNode3;
                ASMClassNodeAdapter classNodeAdapter2;
                if (interfaceClassName == null || (classNodeAdapter2 = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, interfaceClassName, true)) == null || (fieldNode3 = classNodeAdapter2.getField(fieldName, fieldDesc)) == null) continue;
                return fieldNode3;
            }
        }
        if (this.classNode.superName != null && (classNodeAdapter = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, this.classNode.superName, true)) != null && (fieldNode = classNodeAdapter.getField(fieldName, fieldDesc)) != null) {
            return fieldNode;
        }
        return null;
    }

    public ASMFieldNodeAdapter addField(String fieldName, String fieldDesc) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (fieldDesc == null) {
            throw new IllegalArgumentException("fieldDesc must not be null");
        }
        FieldNode fieldNode = new FieldNode(this.getFieldAccessFlags(), fieldName, fieldDesc, null, null);
        if (this.classNode.fields == null) {
            this.classNode.fields = new ArrayList();
        }
        this.classNode.fields.add(fieldNode);
        return new ASMFieldNodeAdapter(fieldNode);
    }

    private int getFieldAccessFlags() {
        return 130;
    }

    public ASMMethodNodeAdapter addDelegatorMethod(ASMMethodNodeAdapter superMethodNode) {
        if (superMethodNode == null) {
            throw new IllegalArgumentException("super method annotation must not be null.");
        }
        String[] exceptions = null;
        if (superMethodNode.getExceptions() != null) {
            exceptions = superMethodNode.getExceptions().toArray(new String[0]);
        }
        ASMMethodNodeAdapter methodNode = new ASMMethodNodeAdapter(this.getInternalName(), new MethodNode(superMethodNode.getAccess(), superMethodNode.getName(), superMethodNode.getDesc(), superMethodNode.getSignature(), exceptions));
        methodNode.addDelegator(superMethodNode.getDeclaringClassInternalName());
        if (this.classNode.methods == null) {
            this.classNode.methods = new ArrayList();
        }
        this.classNode.methods.add(methodNode.getMethodNode());
        return methodNode;
    }

    public void addGetterMethod(String methodName, ASMFieldNodeAdapter fieldNode) {
        if (methodName == null || fieldNode == null) {
            throw new IllegalArgumentException("method name or fieldNode annotation must not be null.");
        }
        String desc = "()" + fieldNode.getDesc();
        MethodNode methodNode = new MethodNode(1, methodName, desc, null, null);
        if (methodNode.instructions == null) {
            methodNode.instructions = new InsnList();
        }
        InsnList instructions = methodNode.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.classNode.name, fieldNode.getName(), fieldNode.getDesc()));
        Type type = Type.getType((String)fieldNode.getDesc());
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(172)));
        if (this.classNode.methods == null) {
            this.classNode.methods = new ArrayList();
        }
        this.classNode.methods.add(methodNode);
    }

    public void addSetterMethod(String methodName, ASMFieldNodeAdapter fieldNode) {
        if (methodName == null || fieldNode == null) {
            throw new IllegalArgumentException("method name or fieldNode annotation must not be null.");
        }
        String desc = "(" + fieldNode.getDesc() + ")V";
        MethodNode methodNode = new MethodNode(1, methodName, desc, null, null);
        if (methodNode.instructions == null) {
            methodNode.instructions = new InsnList();
        }
        InsnList instructions = methodNode.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        Type type = Type.getType((String)fieldNode.getDesc());
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), 1));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, fieldNode.getName(), fieldNode.getDesc()));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        if (this.classNode.methods == null) {
            this.classNode.methods = new ArrayList();
        }
        this.classNode.methods.add(methodNode);
    }

    public void addInterface(String interfaceName) {
        if (interfaceName == null) {
            throw new IllegalArgumentException("interface name must not be null.");
        }
        if (this.classNode.interfaces == null) {
            this.classNode.interfaces = new ArrayList();
        }
        this.classNode.interfaces.add(JavaAssistUtils.javaNameToJvmName(interfaceName));
    }

    public void copyMethod(ASMMethodNodeAdapter methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException("method annotation must not be null");
        }
        ASMMethodInsnNodeRemapper.Builder remapBuilder = new ASMMethodInsnNodeRemapper.Builder();
        remapBuilder.addFilter(methodNode.getDeclaringClassInternalName(), null, null);
        remapBuilder.setOwner(this.classNode.name);
        ASMMethodInsnNodeRemapper remapper = remapBuilder.build();
        methodNode.remapMethodInsnNode(remapper);
        methodNode.remapLocalVariables("this", Type.getObjectType((String)this.classNode.name).getDescriptor());
        if (this.classNode.methods == null) {
            this.classNode.methods = new ArrayList();
        }
        this.classNode.methods.add(methodNode.getMethodNode());
    }

    public boolean hasAnnotation(Class<?> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        String desc = Type.getDescriptor(annotationClass);
        return this.hasAnnotation(desc, this.classNode.invisibleAnnotations) || this.hasAnnotation(desc, this.classNode.visibleAnnotations);
    }

    private boolean hasAnnotation(String annotationClassDesc, List<AnnotationNode> annotationNodes) {
        if (annotationClassDesc == null || annotationNodes == null) {
            return false;
        }
        for (AnnotationNode annotation : annotationNodes) {
            if (annotation.desc == null || !annotation.desc.equals(annotationClassDesc)) continue;
            return true;
        }
        return false;
    }

    public boolean subclassOf(String classInternalName) {
        if (classInternalName == null) {
            return false;
        }
        if (classInternalName.equals("java/lang/Object")) {
            return true;
        }
        ASMClassNodeAdapter classNode = this;
        while (classNode != null) {
            if (classInternalName.equals(classNode.getInternalName())) {
                return true;
            }
            String superClassInternalName = classNode.getSuperClassInternalName();
            if (superClassInternalName == null || superClassInternalName.equals("java/lang/Object")) {
                return false;
            }
            classNode = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, superClassInternalName, true);
        }
        return false;
    }

    public List<ASMClassNodeAdapter> getInnerClasses() {
        if (this.classNode.innerClasses == null) {
            return Collections.emptyList();
        }
        ArrayList<ASMClassNodeAdapter> innerClasses = new ArrayList<ASMClassNodeAdapter>();
        List innerClassNodes = this.classNode.innerClasses;
        for (InnerClassNode node : innerClassNodes) {
            ASMClassNodeAdapter adapter;
            if (node.name == null || (adapter = ASMClassNodeAdapter.get(this.pluginContext, this.classLoader, node.name, true)) == null) continue;
            innerClasses.add(adapter);
        }
        return innerClasses;
    }

    public int getMajorVersion() {
        int majorVersion = this.classNode.version & 0xFFFF;
        return majorVersion;
    }

    public byte[] toByteArray() {
        int majorVersion = this.classNode.version & 0xFFFF;
        int flags = 2;
        if (majorVersion <= 49) {
            flags = 1;
        }
        ASMClassWriter classWriter = new ASMClassWriter(this.pluginContext, flags, this.classLoader);
        this.classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

