/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;

public class WriteFailFutureListener
implements ChannelFutureListener {
    private final Logger logger;
    private final String failMessage;
    private final String successMessage;

    public WriteFailFutureListener(Logger logger, String failMessage) {
        this(logger, failMessage, null);
    }

    public WriteFailFutureListener(Logger logger, String failMessage, String successMessage) {
        if (logger == null) {
            throw new NullPointerException("logger must not be null");
        }
        this.logger = logger;
        this.failMessage = failMessage;
        this.successMessage = successMessage;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            if (this.logger.isWarnEnabled()) {
                Throwable cause = future.getCause();
                this.logger.warn("{} channel:{} Caused:{}", new Object[]{this.failMessage, future.getChannel(), cause.getMessage(), cause});
            }
        } else if (this.successMessage != null && this.logger.isDebugEnabled()) {
            this.logger.debug("{} channel:{}", (Object)this.successMessage, (Object)future.getChannel());
        }
    }
}

