/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConstants;
import java.util.Arrays;

public class HbaseAdminMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final boolean paramsProfile;

    public HbaseAdminMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor, boolean paramsProfile) {
        super(traceContext, descriptor);
        this.paramsProfile = paramsProfile;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(HbasePluginConstants.HBASE_CLIENT_ADMIN);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        String attributes;
        if (this.paramsProfile && (attributes = this.parseAttributes(args)) != null) {
            recorder.recordAttribute(HbasePluginConstants.HBASE_CLIENT_PARAMS, attributes);
        }
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordException(throwable);
    }

    protected String parseAttributes(Object[] args) {
        if (args != null && args.length > 0) {
            return Arrays.asList(args).toString();
        }
        return null;
    }
}

