/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.arcus.ArcusConstants;
import com.navercorp.pinpoint.plugin.arcus.OperationAccessor;
import com.navercorp.pinpoint.plugin.arcus.ServiceCodeAccessor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.Operation;

public class ApiInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;
    private final boolean traceKey;
    private final int keyIndex;

    public ApiInterceptor(TraceContext context, MethodDescriptor targetMethod, boolean traceKey) {
        this.traceContext = context;
        this.methodDescriptor = targetMethod;
        if (traceKey) {
            int index = ApiInterceptor.findFirstString(targetMethod);
            if (index != -1) {
                this.traceKey = true;
                this.keyIndex = index;
            } else {
                this.traceKey = false;
                this.keyIndex = -1;
            }
        } else {
            this.traceKey = false;
            this.keyIndex = -1;
        }
    }

    private static int findFirstString(MethodDescriptor method) {
        if (method == null) {
            return -1;
        }
        String[] methodParams = method.getParameterTypes();
        int minIndex = Math.min(methodParams.length, 3);
        for (int i = 0; i < minIndex; ++i) {
            if (!"java.lang.String".equals(methodParams[i])) continue;
            return i;
        }
        return -1;
    }

    public void before(Object target, Object[] args) {
        block4: {
            Trace trace;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((trace = this.traceContext.currentTraceObject()) == null) {
                return;
            }
            try {
                trace.traceBlockBegin();
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (this.traceKey) {
                Object recordObject = args[this.keyIndex];
                recorder.recordApi(this.methodDescriptor, recordObject, this.keyIndex);
            } else {
                recorder.recordApi(this.methodDescriptor);
            }
            recorder.recordException(throwable);
            if (result instanceof Future && result instanceof OperationAccessor) {
                Operation op = ((OperationAccessor)result)._$PINPOINT$_getOperation();
                if (op != null) {
                    String endPoint;
                    MemcachedNode handlingNode = op.getHandlingNode();
                    if (handlingNode != null && (endPoint = this.getEndPoint(handlingNode)) != null) {
                        recorder.recordEndPoint(endPoint);
                    }
                } else {
                    this.logger.info("operation not found");
                }
            }
            if (target instanceof ServiceCodeAccessor) {
                String serviceCode = ((ServiceCodeAccessor)target)._$PINPOINT$_getServiceCode();
                if (serviceCode != null) {
                    recorder.recordDestinationId(serviceCode);
                    recorder.recordServiceType(ArcusConstants.ARCUS);
                } else {
                    recorder.recordDestinationId("MEMCACHED");
                    recorder.recordServiceType(ArcusConstants.MEMCACHED);
                }
            } else {
                recorder.recordDestinationId("MEMCACHED");
                recorder.recordServiceType(ArcusConstants.MEMCACHED);
            }
            try {
                if (this.isAsynchronousInvocation(target, args, result, throwable)) {
                    AsyncContext asyncContext = recorder.recordNextAsyncContext();
                    ((AsyncContextAccessor)result)._$PINPOINT$_setAsyncContext(asyncContext);
                    if (this.isDebug) {
                        this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
            }
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getEndPoint(MemcachedNode handlingNode) {
        SocketAddress socketAddress = handlingNode.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String hostAddress = this.getHostAddress(inetSocketAddress);
            if (hostAddress == null) {
                this.logger.debug("hostAddress is null");
                return null;
            }
            return HostAndPort.toHostAndPortString((String)hostAddress, (int)inetSocketAddress.getPort());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("invalid socketAddress:{}", (Object)socketAddress);
        }
        return null;
    }

    private String getHostAddress(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    private boolean isAsynchronousInvocation(Object target, Object[] args, Object result, Throwable throwable) {
        if (throwable != null || result == null) {
            return false;
        }
        if (!(result instanceof AsyncContextAccessor)) {
            this.logger.debug("Invalid result object. Need accessor({}).", (Object)AsyncContextAccessor.class.getName());
            return false;
        }
        return true;
    }
}

