#!/bin/bash


if [[ -e /.firstrun ]]; then
    /scripts/init_script.sh
fi

cd /home/quant_group/rabbitmq
touch nohup.out

echo "Starting RabbitMQ..."
> /tmp/rabbitmq.out
nohup /usr/sbin/rabbitmq-server > /tmp/rabbitmq.out &


export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

count=1
until [[ $count -eq 300 ]] || [[ $is_running -eq 1 ]]
do
  let count+=1
  echo "count is $count"
  curl -X GET -H "Authorization: Basic cWE6cWF0ZXN0" "http://localhost:15672/api/definitions"

  if [ $? -eq 0 ]
    then
	    echo "rabbitmq is running rabbitmq-plugins enable rabbitmq_delayed_message_exchange"
	  	rabbitmq-plugins enable rabbitmq_delayed_message_exchange
  		
			curl --request POST \
			  --url http://192.168.6.13/api/etcd/set_env_job_status \
			  --header 'Content-Type: application/json' \
			  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"pending\"}"
			
			# wailt rabbitmq start 
	    for ((i=0;;))
	    do
				num=`grep -n -E 'Server startup complete' /tmp/rabbitmq.out |cut -d ":" -f 1`
				if [ -n "$num" ];then
					is_running=1
					break
				fi
				sleep 10
			done
			
			if [[ $is_running -eq 1 ]]
			  then  
			    echo "rabbitmq is running!!! start execution sync job"
					echo "init rabbit with eos server"
					response=$(curl -X POST -H "Content-Type: application/json" -d "{\"namespace\":\"$NAMESPACE\"}" "http://192.168.6.13/api/etcd/init_env_rabbitmq_config")
			  	echo $response
				else
			    echo "rabbitmq is not running!!! Do not execution sync job"
			fi

			curl --request POST \
			  --url http://192.168.6.13/api/etcd/set_env_job_status \
			  --header 'Content-Type: application/json' \
			  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"done\"}"
			
	  	tail -f /tmp/rabbitmq.out
    else
      echo "rabbitmq is not running"
      sleep 1
  fi
done




