/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.DefaultTraceFactory;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceFactoryProvider
implements Provider<TraceFactory> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Binder<Trace> binder;
    private final Provider<BaseTraceFactory> baseTraceFactoryProvider;

    @Inject
    public TraceFactoryProvider(Provider<BaseTraceFactory> baseTraceFactoryProvider, Binder<Trace> binder) {
        this.baseTraceFactoryProvider = (Provider)Assert.requireNonNull(baseTraceFactoryProvider, (String)"baseTraceFactoryProvider must not be null");
        this.binder = (Binder)Assert.requireNonNull(binder, (String)"binder must not be null");
    }

    public TraceFactory get() {
        BaseTraceFactory baseTraceFactory = (BaseTraceFactory)this.baseTraceFactoryProvider.get();
        DefaultTraceFactory traceFactory = new DefaultTraceFactory(baseTraceFactory, this.binder);
        return traceFactory;
    }
}

