/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;

public final class BootLogger {
    private final String messagePattern;
    private final PrintStream out;
    private final PrintStream err;

    private static void setup() {
    }

    public BootLogger(String loggerName) {
        this(loggerName, System.out, System.err);
    }

    BootLogger(String loggerName, PrintStream out, PrintStream err) {
        if (loggerName == null) {
            throw new NullPointerException("loggerName must not be null");
        }
        this.messagePattern = "{0,date,yyyy-MM-dd HH:mm:ss} [{1}](" + loggerName + ") {2}{3}";
        this.out = out;
        this.err = err;
    }

    public static BootLogger getLogger(String loggerName) {
        return new BootLogger(loggerName);
    }

    private String format(String logLevel, String msg, String exceptionMessage) {
        exceptionMessage = this.defaultString(exceptionMessage, "");
        MessageFormat messageFormat = new MessageFormat(this.messagePattern);
        long date = System.currentTimeMillis();
        Object[] parameter = new Object[]{date, logLevel, msg, exceptionMessage};
        return messageFormat.format(parameter);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        String formatMessage = this.format("INFO ", msg, "");
        this.out.println(formatMessage);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable throwable) {
        String exceptionMessage = this.toString(throwable);
        String formatMessage = this.format("WARN ", msg, exceptionMessage);
        this.err.println(formatMessage);
    }

    private String toString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private String defaultString(String exceptionMessage, String defaultValue) {
        if (exceptionMessage == null) {
            return defaultValue;
        }
        return exceptionMessage;
    }

    static {
        BootLogger.setup();
    }
}

