/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultTraceHeaderReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeaderReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeaderState;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.NameSpaceCheckFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.NameSpaceChecker;
import com.navercorp.pinpoint.common.util.Assert;

public class RequestTraceReader<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final RequestAdaptor<T> requestAdaptor;
    private final boolean async;
    private final TraceHeaderReader<T> traceHeaderReader;
    private final NameSpaceChecker<T> nameSpaceChecker;

    public RequestTraceReader(TraceContext traceContext, RequestAdaptor<T> requestAdaptor) {
        this(traceContext, requestAdaptor, false);
    }

    public RequestTraceReader(TraceContext traceContext, RequestAdaptor<T> requestAdaptor, boolean async) {
        this.traceContext = Assert.requireNonNull(traceContext, "traceContext must not be null");
        this.requestAdaptor = Assert.requireNonNull(requestAdaptor, "requestAdaptor must not be null");
        this.traceHeaderReader = new DefaultTraceHeaderReader<T>(requestAdaptor);
        this.async = async;
        String applicationNamespace = traceContext.getProfilerConfig().getApplicationNamespace();
        this.nameSpaceChecker = NameSpaceCheckFactory.newNamespace(requestAdaptor, applicationNamespace);
    }

    public Trace read(T request) {
        Assert.requireNonNull(request, "request must not be null");
        TraceHeader traceHeader = this.traceHeaderReader.read(request);
        TraceHeaderState state = traceHeader.getState();
        if (state == TraceHeaderState.DISABLE) {
            Trace trace = this.traceContext.disableSampling();
            if (this.isDebug) {
                this.logger.debug("Remote call sampling flag found. skip trace requestUrl:{}, remoteAddr:{}", (Object)this.requestAdaptor.getRpcName(request), (Object)this.requestAdaptor.getRemoteAddress(request));
            }
            return trace;
        }
        if (state == TraceHeaderState.CONTINUE) {
            if (!this.nameSpaceChecker.checkNamespace(request)) {
                return this.newTrace(request);
            }
            return this.continueTrace(request, traceHeader);
        }
        if (state == TraceHeaderState.NEW_TRACE) {
            return this.newTrace(request);
        }
        throw new UnsupportedOperationException("Unsupported state=" + (Object)((Object)state));
    }

    private Trace newTrace(T request) {
        Trace trace = this.newTrace();
        if (trace.canSampled()) {
            if (this.isDebug) {
                this.logger.debug("TraceID not exist. start new trace. requestUrl:{}, remoteAddr:{}", (Object)this.requestAdaptor.getRpcName(request), (Object)this.requestAdaptor.getRemoteAddress(request));
            }
        } else if (this.isDebug) {
            this.logger.debug("TraceID not exist. canSampled is false. skip trace. requestUrl:{}, remoteAddr:{}", (Object)this.requestAdaptor.getRpcName(request), (Object)this.requestAdaptor.getRemoteAddress(request));
        }
        return trace;
    }

    public Trace continueTrace(T request, TraceHeader traceHeader) {
        TraceId traceId = this.newTraceId(traceHeader);
        Trace trace = this.continueTrace(traceId);
        if (trace.canSampled()) {
            if (this.isDebug) {
                this.logger.debug("TraceID exist. continue trace. traceId:{}, requestUrl:{}, remoteAddr:{}", traceId, this.requestAdaptor.getRpcName(request), this.requestAdaptor.getRemoteAddress(request));
            }
        } else if (this.isDebug) {
            this.logger.debug("TraceID exist. camSampled is false. skip trace. traceId:{}, requestUrl:{}, remoteAddr:{}", traceId, this.requestAdaptor.getRpcName(request), this.requestAdaptor.getRemoteAddress(request));
        }
        return trace;
    }

    private TraceId newTraceId(TraceHeader traceHeader) {
        String transactionId = traceHeader.getTransactionId();
        long parentSpanId = traceHeader.getParentSpanId();
        long spanId = traceHeader.getSpanId();
        short flags = traceHeader.getFlags();
        TraceId id = this.traceContext.createTraceId(transactionId, parentSpanId, spanId, flags);
        return id;
    }

    private Trace continueTrace(TraceId traceId) {
        if (this.async) {
            return this.traceContext.continueAsyncTraceObject(traceId);
        }
        return this.traceContext.continueTraceObject(traceId);
    }

    private Trace newTrace() {
        if (this.async) {
            return this.traceContext.newAsyncTraceObject();
        }
        return this.traceContext.newTraceObject();
    }
}

