/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.StatClientFactory;
import com.navercorp.pinpoint.profiler.context.thrift.BypassMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.TcpDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.UdpDataSenderFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatDataSenderProvider
implements Provider<DataSender> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String UDP_EXECUTOR_NAME = "Pinpoint-UdpStatDataExecutor";
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final String ip;
    private final int port;
    private final int writeQueueSize;
    private final int timeout;
    private final int sendBufferSize;
    private final String ioType;
    private final String transportType;
    private final MessageConverter<TBase<?, ?>> messageConverter;

    @Inject
    public StatDataSenderProvider(ProfilerConfig profilerConfig, @StatClientFactory Provider<PinpointClientFactory> clientFactoryProvider) {
        Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.clientFactoryProvider = (Provider)Assert.requireNonNull(clientFactoryProvider, (String)"clientFactoryProvider must not be null");
        this.ip = profilerConfig.getCollectorStatServerIp();
        this.port = profilerConfig.getCollectorStatServerPort();
        this.writeQueueSize = profilerConfig.getStatDataSenderWriteQueueSize();
        this.timeout = profilerConfig.getStatDataSenderSocketTimeout();
        this.sendBufferSize = profilerConfig.getStatDataSenderSocketSendBufferSize();
        this.ioType = profilerConfig.getStatDataSenderSocketType();
        this.transportType = profilerConfig.getStatDataSenderTransportType();
        this.messageConverter = new BypassMessageConverter();
    }

    public DataSender get() {
        if ("TCP".equalsIgnoreCase(this.transportType)) {
            if ("OIO".equalsIgnoreCase(this.ioType)) {
                this.logger.warn("TCP transport not support OIO type.(only support NIO)");
            }
            PinpointClientFactory pinpointClientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
            ThriftMessageSerializer messageSerializer = new ThriftMessageSerializer(this.messageConverter);
            return new TcpDataSender("StatDataSender", this.ip, this.port, pinpointClientFactory, messageSerializer);
        }
        UdpDataSenderFactory factory = new UdpDataSenderFactory(this.ip, this.port, UDP_EXECUTOR_NAME, this.writeQueueSize, this.timeout, this.sendBufferSize, this.messageConverter);
        return factory.create(this.ioType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatDataSenderProvider{");
        sb.append("ip='").append(this.ip).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", writeQueueSize=").append(this.writeQueueSize);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", sendBufferSize=").append(this.sendBufferSize);
        sb.append(", ioType='").append(this.ioType).append('\'');
        sb.append(", transportType='").append(this.transportType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

