/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootSupport;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTrace
implements Trace,
TraceRootSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultTrace.class.getName());
    private static final boolean isWarn = logger.isWarnEnabled();
    private static final boolean isDebug = logger.isDebugEnabled();
    private final boolean sampling;
    private final CallStack<SpanEvent> callStack;
    private final Storage storage;
    private final Span span;
    private final SpanRecorder spanRecorder;
    private final WrappedSpanEventRecorder wrappedSpanEventRecorder;
    private final AsyncContextFactory asyncContextFactory;
    private final ActiveTraceHandle activeTraceHandle;
    private boolean closed = false;
    private final DefaultTraceScopePool scopePool = new DefaultTraceScopePool();

    public DefaultTrace(Span span, CallStack<SpanEvent> callStack, Storage storage, AsyncContextFactory asyncContextFactory, boolean sampling, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, ActiveTraceHandle activeTraceHandle) {
        this.span = (Span)Assert.requireNonNull((Object)span, (String)"span must not be null");
        this.callStack = (CallStack)Assert.requireNonNull(callStack, (String)"callStack must not be null");
        this.storage = (Storage)Assert.requireNonNull((Object)storage, (String)"storage must not be null");
        this.sampling = sampling;
        this.asyncContextFactory = (AsyncContextFactory)Assert.requireNonNull((Object)asyncContextFactory, (String)"asyncContextFactory must not be null");
        this.spanRecorder = (SpanRecorder)Assert.requireNonNull((Object)spanRecorder, (String)"spanRecorder must not be null");
        this.wrappedSpanEventRecorder = (WrappedSpanEventRecorder)Assert.requireNonNull((Object)wrappedSpanEventRecorder, (String)"wrappedSpanEventRecorder must not be null");
        this.activeTraceHandle = (ActiveTraceHandle)Assert.requireNonNull((Object)activeTraceHandle, (String)"activeTraceHandle must not be null");
        this.setCurrentThread();
    }

    @Override
    public TraceRoot getTraceRoot() {
        return this.span.getTraceRoot();
    }

    private SpanEventRecorder wrappedSpanEventRecorder(WrappedSpanEventRecorder wrappedSpanEventRecorder, SpanEvent spanEvent) {
        wrappedSpanEventRecorder.setWrapped(spanEvent);
        return wrappedSpanEventRecorder;
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        if (this.closed) {
            if (isWarn) {
                this.stackDump("already closed trace");
            }
            SpanEvent dummy = this.dummySpanEvent();
            return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, dummy);
        }
        SpanEvent spanEvent = this.newSpanEvent(stackId);
        this.callStack.push(spanEvent);
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private void stackDump(String caused) {
        PinpointException exception = new PinpointException(caused);
        logger.warn("[DefaultTrace] Corrupted call stack found TraceRoot:{}, CallStack:{}", new Object[]{this.getTraceRoot(), this.callStack, exception});
    }

    public void traceBlockEnd() {
        this.traceBlockEnd(-1);
    }

    public void traceBlockEnd(int stackId) {
        if (this.closed) {
            if (isWarn) {
                this.stackDump("already closed trace");
            }
            return;
        }
        SpanEvent spanEvent = this.callStack.pop();
        if (spanEvent == null) {
            if (isWarn) {
                this.stackDump("call stack is empty.");
            }
            return;
        }
        if (this.isDummySpanEvent(spanEvent)) {
            if (isDebug) {
                logger.debug("[DefaultTrace] Skip dummy spanEvent");
            }
            return;
        }
        if (spanEvent.getStackId() != stackId && isWarn) {
            this.stackDump("not matched stack id. expected=" + stackId + ", current=" + spanEvent.getStackId());
        }
        if (spanEvent.isTimeRecording()) {
            spanEvent.markAfterTime();
        }
        this.logSpan(spanEvent);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            logger.warn("Already closed trace");
            return;
        }
        this.closed = true;
        long afterTime = System.currentTimeMillis();
        if (!this.callStack.empty()) {
            if (isWarn) {
                this.stackDump("not empty call stack");
            }
        } else {
            if (this.span.isTimeRecording()) {
                this.span.markAfterTime(afterTime);
            }
            this.logSpan(this.span);
        }
        this.storage.close();
        this.purgeActiveTrace(afterTime);
    }

    private void purgeActiveTrace(long currentTime) {
        ActiveTraceHandle copy = this.activeTraceHandle;
        if (copy != null) {
            copy.purge(currentTime);
        }
    }

    void flush() {
        this.storage.flush();
        this.closed = true;
    }

    public TraceId getTraceId() {
        return this.getTraceRoot().getTraceId();
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.span.getStartTime();
    }

    public Thread getBindThread() {
        return null;
    }

    public long getThreadId() {
        return this.getTraceRoot().getShared().getThreadId();
    }

    private void setCurrentThread() {
        long threadId = Thread.currentThread().getId();
        this.setBindThread(threadId);
    }

    private void setBindThread(long threadId) {
        this.getTraceRoot().getShared().setThreadId(threadId);
    }

    public boolean canSampled() {
        return this.sampling;
    }

    public boolean isRoot() {
        return this.getTraceId().isRoot();
    }

    private void logSpan(SpanEvent spanEvent) {
        this.storage.store(spanEvent);
    }

    private void logSpan(Span span) {
        this.storage.store(span);
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        return this.callStack.empty();
    }

    public AsyncTraceId getAsyncTraceId() {
        return this.asyncContextFactory.newAsyncTraceId(this.getTraceRoot());
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            if (isWarn) {
                this.stackDump("call stack is empty");
            }
            spanEvent = this.dummySpanEvent();
        }
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent newSpanEvent(int stackId) {
        SpanEvent spanEvent = this.callStack.getFactory().newInstance();
        spanEvent.markStartTime();
        spanEvent.setStackId(stackId);
        return spanEvent;
    }

    @VisibleForTesting
    SpanEvent dummySpanEvent() {
        return this.callStack.getFactory().dummyInstance();
    }

    @VisibleForTesting
    boolean isDummySpanEvent(SpanEvent spanEvent) {
        return this.callStack.getFactory().isDummy(spanEvent);
    }

    public int getCallStackFrameId() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public TraceScope getScope(String name) {
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        return this.scopePool.add(name);
    }

    public String toString() {
        return "DefaultTrace{sampling=" + this.sampling + ", traceRoot=" + this.getTraceRoot() + '}';
    }
}

