/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.util;

import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.ResinVersionUtil;
import java.lang.management.ManagementFactory;

public class JdkAndContainerUtil {
    private static final ILogger logger = LoggerFactory.getLogger(JdkAndContainerUtil.class.getName());
    private static final String RESIN_CLASS = "/com/caucho/server/resin/Resin.class";
    private static final String WEBLOGIC_CLASS = "/weblogic/Server.class";
    private static final String WEBSPHERE_CLASS = "/com/ibm/websphere/product/VersionInfo.class";

    public static boolean isResin() {
        Class<JdkAndContainerUtil> c = JdkAndContainerUtil.class;
        return c.getResource(RESIN_CLASS) != null && ResinVersionUtil.checkResin4Version();
    }

    public static boolean isWebLogic() {
        Class<JdkAndContainerUtil> c = JdkAndContainerUtil.class;
        return c.getResource(WEBLOGIC_CLASS) != null;
    }

    public static boolean isWebSphere() {
        Class<JdkAndContainerUtil> c = JdkAndContainerUtil.class;
        return c.getResource(WEBSPHERE_CLASS) != null;
    }

    public static boolean isIbmJdk() {
        try {
            String upperVendor;
            String upperCaseVendor;
            String vmVendor = ManagementFactory.getRuntimeMXBean().getVmVendor();
            if (vmVendor != null && (upperCaseVendor = vmVendor.toUpperCase()).contains("IBM")) {
                return true;
            }
            String vmVendorEnvironment = System.getProperty("java.vendor");
            return vmVendorEnvironment != null && (upperVendor = vmVendorEnvironment.toUpperCase()).contains("IBM");
        }
        catch (Exception e) {
            logger.error("Failed judge IBM environment .", e);
            return false;
        }
    }

    public static enum ExcludeClassLoaderEnum {
        Resin(new String[]{"com/caucho/loader/DynamicClassLoader", "java/net/URLClassLoader"}),
        Weblogic(new String[]{"com/oracle/classloader/weblogic/LaunchClassLoader", "com/oracle/classloader/PolicyClassLoader"}),
        IbmJdk(new String[]{"java/net/URLClassLoader"}),
        WebSphere(new String[]{"java/net/URLClassLoader"});

        private String[] values;

        private ExcludeClassLoaderEnum(String[] values) {
            this.values = values;
        }

        public String[] getValues() {
            return this.values;
        }
    }
}

