/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdk.http.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.plugin.jdk.http.ConnectedGetter;
import com.navercorp.pinpoint.plugin.jdk.http.ConnectingGetter;
import com.navercorp.pinpoint.plugin.jdk.http.HttpURLConnectionClientHeaderAdaptor;
import com.navercorp.pinpoint.plugin.jdk.http.JdkHttpClientRequestAdaptor;
import com.navercorp.pinpoint.plugin.jdk.http.JdkHttpConstants;
import com.navercorp.pinpoint.plugin.jdk.http.JdkHttpPluginConfig;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpURLConnectionInterceptor
implements AroundInterceptor {
    private static final Object TRACE_BLOCK_BEGIN_MARKER = new Object();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope scope;
    private final ClientRequestRecorder<HttpURLConnection> clientRequestRecorder;
    private final RequestTraceWriter<HttpURLConnection> requestTraceWriter;

    public HttpURLConnectionInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
        JdkHttpPluginConfig config = new JdkHttpPluginConfig(traceContext.getProfilerConfig());
        JdkHttpClientRequestAdaptor clientRequestAdaptor = new JdkHttpClientRequestAdaptor();
        this.clientRequestRecorder = new ClientRequestRecorder(config.isParam(), (ClientRequestAdaptor)clientRequestAdaptor);
        HttpURLConnectionClientHeaderAdaptor clientHeaderAdaptor = new HttpURLConnectionClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        HttpURLConnection request = (HttpURLConnection)target;
        boolean connected = false;
        if (target instanceof ConnectedGetter) {
            connected = ((ConnectedGetter)target)._$PINPOINT$_isConnected();
        }
        boolean connecting = false;
        if (target instanceof ConnectingGetter) {
            connecting = ((ConnectingGetter)target)._$PINPOINT$_isConnecting();
        }
        if (connected || connecting) {
            return;
        }
        boolean sampling = trace.canSampled();
        if (!sampling) {
            if (request != null) {
                this.requestTraceWriter.write((Object)request);
            }
            return;
        }
        this.scope.getCurrentInvocation().setAttachment(TRACE_BLOCK_BEGIN_MARKER);
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(JdkHttpConstants.SERVICE_TYPE);
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        if (request != null) {
            String host = this.getHost(request);
            this.requestTraceWriter.write((Object)request, nextId, host);
        }
    }

    private String getHost(HttpURLConnection httpURLConnection) {
        URL url = httpURLConnection.getURL();
        if (url != null) {
            String host = url.getHost();
            int port = url.getPort();
            if (host != null) {
                return JdkHttpClientRequestAdaptor.getEndpoint(host, port);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        Object marker = this.scope.getCurrentInvocation().getAttachment();
        if (marker != TRACE_BLOCK_BEGIN_MARKER) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            HttpURLConnection request = (HttpURLConnection)target;
            if (request != null) {
                this.clientRequestRecorder.record(recorder, (Object)request, throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

