/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.websphere;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.common.util.Assert;
import java.util.List;

public class WebsphereConfiguration {
    private final boolean enable;
    private final boolean traceRequestParam;
    private final List<String> bootstrapMains;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final Filter<String> excludeUrlFilter;
    private final Filter<String> excludeProfileMethodFilter;
    private final boolean hidePinpointHeader;

    public WebsphereConfiguration(ProfilerConfig config) {
        Assert.requireNonNull((Object)config, (String)"config must not be null");
        this.enable = config.readBoolean("profiler.websphere.enable", true);
        this.bootstrapMains = config.readList("profiler.websphere.bootstrap.main");
        this.traceRequestParam = config.readBoolean("profiler.websphere.tracerequestparam", true);
        this.realIpHeader = config.readString("profiler.websphere.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.websphere.realipemptyvalue", null);
        String excludeURL = config.readString("profiler.websphere.excludeurl", "");
        this.excludeUrlFilter = !excludeURL.isEmpty() ? new ExcludePathFilter(excludeURL) : new SkipFilter();
        String excludeProfileMethod = config.readString("profiler.websphere.excludemethod", "");
        this.excludeProfileMethodFilter = !excludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(excludeProfileMethod) : new SkipFilter();
        this.hidePinpointHeader = config.readBoolean("profiler.websphere.hidepinpointheader", true);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebsphereConfiguration{");
        sb.append("enable=").append(this.enable);
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append('}');
        return sb.toString();
    }
}

