/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.common.base.Objects;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.test.Expectations;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedAnnotation;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedSql;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedTrace;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedTraceField;
import com.navercorp.pinpoint.bootstrap.plugin.test.PluginTestVerifier;
import com.navercorp.pinpoint.bootstrap.plugin.test.TraceType;
import com.navercorp.pinpoint.common.service.AnnotationKeyRegistryService;
import com.navercorp.pinpoint.common.service.ServiceTypeRegistryService;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.LoggingInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.AnnotationKeyUtils;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.DefaultLocalAsyncId;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import com.navercorp.pinpoint.test.Item;
import com.navercorp.pinpoint.test.ListenableDataSender;
import com.navercorp.pinpoint.test.MethodDescriptionUtils;
import com.navercorp.pinpoint.test.OrderedSpanRecorder;
import com.navercorp.pinpoint.test.TestTcpDataSender;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PluginVerifierExternalAdaptor
implements PluginTestVerifier {
    private final List<Short> ignoredServiceTypes = new ArrayList<Short>();
    private final DefaultApplicationContext applicationContext;

    public PluginVerifierExternalAdaptor(DefaultApplicationContext applicationContext) {
        this.applicationContext = (DefaultApplicationContext)Assert.requireNonNull((Object)applicationContext, (String)"applicationContext must not be null");
    }

    public DefaultApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void verifyServerType(String serviceTypeName) {
        ServiceType actualType;
        DefaultApplicationContext applicationContext = this.getApplicationContext();
        ServiceType expectedType = this.findServiceType(serviceTypeName);
        if (!expectedType.equals(actualType = applicationContext.getAgentInformation().getServerType())) {
            throw new AssertionError((Object)("ResolvedExpectedTrace server type: " + expectedType.getName() + "[" + expectedType.getCode() + "] but was " + actualType + "[" + actualType.getCode() + "]"));
        }
    }

    public void verifyServerInfo(String expected) {
        String actualName = this.getServerMetaData().getServerInfo();
        if (!actualName.equals(expected)) {
            throw new AssertionError((Object)("ResolvedExpectedTrace server name [" + expected + "] but was [" + actualName + "]"));
        }
    }

    public void verifyConnector(String protocol, int port) {
        Map connectorMap = this.getServerMetaData().getConnectors();
        String actualProtocol = (String)connectorMap.get(port);
        if (actualProtocol == null || !actualProtocol.equals(protocol)) {
            throw new AssertionError((Object)("ResolvedExpectedTrace protocol [" + protocol + "] at port [" + port + "] but was [" + actualProtocol + "]"));
        }
    }

    public void verifyService(String name, List<String> libs) {
        List serviceInfos = this.getServerMetaData().getServiceInfos();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (!serviceInfo.getServiceName().equals(name)) continue;
            List actualLibs = serviceInfo.getServiceLibs();
            if (actualLibs.size() != libs.size()) {
                throw new AssertionError((Object)("ResolvedExpectedTrace service [" + name + "] with libraries [" + libs + "] but was [" + actualLibs + "]"));
            }
            for (String lib : libs) {
                if (!actualLibs.contains(lib)) {
                    throw new AssertionError((Object)("ResolvedExpectedTrace service [" + name + "] with libraries [" + libs + "] but was [" + actualLibs + "]"));
                }
            }
            return;
        }
        throw new AssertionError((Object)("ResolvedExpectedTrace service [" + name + "] with libraries [" + libs + "] but there is no such service"));
    }

    private boolean isIgnored(Object obj) {
        short serviceType = -1;
        if (obj instanceof Span) {
            serviceType = ((Span)obj).getServiceType();
        } else if (obj instanceof SpanEvent) {
            serviceType = ((SpanEvent)obj).getServiceType();
        }
        return this.ignoredServiceTypes.contains(serviceType);
    }

    public void verifyTraceCount(int expected) {
        int actual = 0;
        for (Object obj : this.getRecorder()) {
            if (this.isIgnored(obj)) continue;
            ++actual;
        }
        if (expected != actual) {
            throw new AssertionError((Object)("ResolvedExpectedTrace count: " + expected + ", actual: " + actual));
        }
    }

    private ServiceType findServiceType(String name) {
        ServiceTypeRegistryService serviceTypeRegistryService = this.getServiceTypeRegistry();
        ServiceType serviceType = serviceTypeRegistryService.findServiceTypeByName(name);
        if (serviceType == ServiceType.UNDEFINED) {
            throw new AssertionError((Object)("No such service type: " + name));
        }
        return serviceType;
    }

    private Class<?> resolveSpanClass(TraceType type) {
        switch (type) {
            case ROOT: {
                return Span.class;
            }
            case EVENT: {
                return SpanEvent.class;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public void verifyDiscreteTrace(ExpectedTrace ... expectations) {
        this.verifyDiscreteTraceBlock(expectations, null);
    }

    public void verifyDiscreteTraceBlock(ExpectedTrace[] expectations, Integer asyncId) {
        if (ArrayUtils.isEmpty((Object[])expectations)) {
            throw new IllegalArgumentException("No expectations");
        }
        ExpectedTrace expected = expectations[0];
        ResolvedExpectedTrace resolved = this.resolveExpectedTrace(expected, asyncId);
        int i = 0;
        Iterator<Object> iterator = this.getRecorder().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ActualTrace actual = this.wrap(next);
            try {
                this.verifySpan(resolved, actual);
            }
            catch (AssertionError e) {
                continue;
            }
            iterator.remove();
            this.verifyAsyncTraces(expected, actual);
            if (++i == expectations.length) {
                return;
            }
            expected = expectations[i];
            resolved = this.resolveExpectedTrace(expected, asyncId);
        }
        throw new AssertionError((Object)("Failed to match " + i + "th expectation: " + resolved));
    }

    public void verifyTrace(ExpectedTrace ... expectations) {
        if (ArrayUtils.isEmpty((Object[])expectations)) {
            throw new IllegalArgumentException("No expectations");
        }
        for (ExpectedTrace expected : expectations) {
            ResolvedExpectedTrace resolved = this.resolveExpectedTrace(expected, null);
            Item item = this.popItem();
            if (item == null) {
                throw new AssertionError((Object)("Expected a " + resolved.toString() + " but there is no trace"));
            }
            Object actual = item.getValue();
            ActualTrace wrapped = this.wrap(actual);
            this.verifySpan(resolved, wrapped);
            this.verifyAsyncTraces(expected, wrapped);
        }
    }

    private void verifyAsyncTraces(ExpectedTrace expected, ActualTrace wrapped) throws AssertionError {
        ExpectedTrace[] asyncTraces = expected.getAsyncTraces();
        if (asyncTraces != null && asyncTraces.length > 0) {
            Integer asyncId = wrapped.getNextAsyncId();
            if (asyncId == null) {
                throw new AssertionError((Object)("Expected async traces triggered but nextAsyncId is not present: " + wrapped));
            }
            this.verifyDiscreteTraceBlock(asyncTraces, asyncId);
        }
    }

    private ResolvedExpectedTrace resolveExpectedTrace(ExpectedTrace expected, Integer asyncId) throws AssertionError {
        ServiceType serviceType = this.findServiceType(expected.getServiceType());
        Class<?> spanClass = this.resolveSpanClass(expected.getType());
        int apiId = this.getApiId(expected);
        return new ResolvedExpectedTrace(spanClass, serviceType, apiId, expected.getException(), expected.getRpc(), expected.getEndPoint(), expected.getRemoteAddr(), expected.getDestinationId(), expected.getAnnotations(), asyncId);
    }

    private int getApiId(ExpectedTrace expected) {
        Member method = expected.getMethod();
        if (method == null) {
            if (expected.getMethodSignature() == null) {
                throw new RuntimeException("Method or MethodSignature is null");
            }
            String methodSignature = expected.getMethodSignature();
            if (methodSignature.indexOf(40) != -1) {
                methodSignature = MethodDescriptionUtils.toJavaMethodDescriptor(methodSignature);
            }
            return this.findApiId(methodSignature);
        }
        return this.findApiId(method);
    }

    public void ignoreServiceType(String ... serviceTypes) {
        for (String serviceType : serviceTypes) {
            ServiceType t = this.findServiceType(serviceType);
            this.ignoredServiceTypes.add(t.getCode());
        }
    }

    private static void appendAnnotations(StringBuilder builder, List<Annotation> annotations) {
        boolean first = true;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(PluginVerifierExternalAdaptor.toString(annotation));
            }
        }
    }

    private static String toString(Annotation a) {
        return a.getAnnotationKey() + "=" + a.getValue();
    }

    private Injector getInjector() {
        return this.applicationContext.getInjector();
    }

    private ServiceTypeRegistryService getServiceTypeRegistry() {
        return (ServiceTypeRegistryService)this.getInjector().getInstance(ServiceTypeRegistryService.class);
    }

    private AnnotationKeyRegistryService getAnnotationKeyRegistryService() {
        Injector injector = this.getInjector();
        return (AnnotationKeyRegistryService)injector.getInstance(AnnotationKeyRegistryService.class);
    }

    private ActualTrace wrap(Object obj) {
        if (obj instanceof Span) {
            Span span = (Span)obj;
            return new SpanFacade(span);
        }
        if (obj instanceof SpanEvent) {
            SpanEvent spanEvent = (SpanEvent)obj;
            return new SpanEventFacade(spanEvent);
        }
        throw new IllegalArgumentException("Unexpected type: " + obj.getClass());
    }

    private static boolean equals(Object expected, Object actual) {
        return expected == null || expected.equals(actual);
    }

    private static boolean equals(Object expected, String actual) {
        if (expected instanceof ExpectedTraceField) {
            return ((ExpectedTraceField)expected).isEquals(actual);
        }
        return expected == null || expected.equals(actual);
    }

    private void verifySpan(ResolvedExpectedTrace expected, ActualTrace actual) {
        int actualLen;
        if (!expected.type.equals(actual.getType())) {
            throw new AssertionError((Object)("Expected an instance of " + expected.type.getSimpleName() + " but was " + actual.getType().getName() + ". expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.serviceType.getCode(), actual.getServiceType())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with serviceType[" + expected.serviceType.getCode() + "] but was [" + actual.getServiceType() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.apiId, actual.getApiId())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with apiId[" + expected.apiId + "] but was [" + actual.getApiId() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.rpc, actual.getRpc())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with rpc[" + expected.rpc + "] but was [" + actual.getRpc() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.endPoint, actual.getEndPoint())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with endPoint[" + expected.endPoint + "] but was [" + actual.getEndPoint() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.remoteAddr, actual.getRemoteAddr())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with remoteAddr[" + expected.remoteAddr + "] but was [" + actual.getRemoteAddr() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)expected.destinationId, actual.getDestinationId())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with destinationId[" + expected.destinationId + "] but was [" + actual.getDestinationId() + "]. expected: " + expected + ", was: " + actual));
        }
        if (!PluginVerifierExternalAdaptor.equals((Object)this.getAsyncId(expected), actual.getAsyncId())) {
            throw new AssertionError((Object)("Expected a " + expected.type.getSimpleName() + " with asyncId[" + expected.localAsyncId + "] but was [" + actual.getAsyncId() + "]. expected: " + expected + ", was: " + actual));
        }
        if (expected.exception != null) {
            IntStringValue actualExceptionInfo = actual.getExceptionInfo();
            if (actualExceptionInfo != null) {
                String actualExceptionClassName = this.getTestTcpDataSender().getString(actualExceptionInfo.getIntValue());
                String actualExceptionMessage = actualExceptionInfo.getStringValue();
                this.verifyException(expected.exception, actualExceptionClassName, actualExceptionMessage);
            } else {
                throw new AssertionError((Object)("Expected [" + expected.exception.getClass().getName() + "] but was none"));
            }
        }
        List<Annotation> actualAnnotations = actual.getAnnotations();
        int len = expected.annotations == null ? 0 : expected.annotations.length;
        int n = actualLen = actualAnnotations == null ? 0 : actualAnnotations.size();
        if (actualLen != len) {
            throw new AssertionError((Object)("Expected [" + len + "] annotations but was [" + actualLen + "], expected: " + expected + ", was: " + actual));
        }
        for (int i = 0; i < len; ++i) {
            ExpectedAnnotation expect = expected.annotations[i];
            AnnotationKey expectedAnnotationKey = this.getAnnotationKeyRegistryService().findAnnotationKeyByName(expect.getKeyName());
            Annotation actualAnnotation = actualAnnotations.get(i);
            if (expectedAnnotationKey.getCode() != actualAnnotation.getAnnotationKey()) {
                throw new AssertionError((Object)("Code Different, Expected " + i + "th annotation [" + expectedAnnotationKey.getCode() + "=" + expect.getValue() + "] but was [" + PluginVerifierExternalAdaptor.toString(actualAnnotation) + "], expected: " + expected + ", was: " + actual));
            }
            if (expectedAnnotationKey == AnnotationKey.SQL_ID && expect instanceof ExpectedSql) {
                this.verifySql((ExpectedSql)expect, actualAnnotation);
                continue;
            }
            Object expectedValue = expect.getValue();
            if (expectedValue == Expectations.anyAnnotationValue()) continue;
            if (AnnotationKeyUtils.isCachedArgsKey((int)expectedAnnotationKey.getCode())) {
                expectedValue = this.getTestTcpDataSender().getStringId(expectedValue.toString());
            }
            if (!Objects.equal((Object)expectedValue, (Object)actualAnnotation.getValue())) {
                throw new AssertionError((Object)("Value Different, Expected " + i + "th annotation [" + expectedAnnotationKey.getCode() + "=" + expect.getValue() + "] but was [" + PluginVerifierExternalAdaptor.toString(actualAnnotation) + "], expected: " + expected + ", was: " + actual));
            }
        }
    }

    private Integer getAsyncId(ResolvedExpectedTrace expected) {
        if (expected.localAsyncId == null) {
            return null;
        }
        return expected.localAsyncId.getAsyncId();
    }

    private void verifyException(Exception expectedException, String actualExceptionClassName, String actualExceptionMessage) {
        String expectedExceptionClassName = expectedException.getClass().getName();
        String expectedExceptionMessage = StringUtils.abbreviate((String)expectedException.getMessage(), (int)256);
        if (!Objects.equal((Object)actualExceptionClassName, (Object)expectedExceptionClassName)) {
            throw new AssertionError((Object)("Expected [" + expectedExceptionClassName + "] but was [" + actualExceptionClassName + "]"));
        }
        if (!Objects.equal((Object)actualExceptionMessage, (Object)expectedExceptionMessage)) {
            throw new AssertionError((Object)("Expected exception with message [" + expectedExceptionMessage + "] but was [" + actualExceptionMessage + "]"));
        }
    }

    private void verifySql(ExpectedSql expected, Annotation actual) {
        int id = this.getTestTcpDataSender().getSqlId(expected.getQuery());
        IntStringStringValue value = (IntStringStringValue)actual.getValue();
        if (value.getIntValue() != id) {
            String actualQuery = this.getTestTcpDataSender().getSql(value.getIntValue());
            throw new AssertionError((Object)("Expected sql [" + id + ": " + expected.getQuery() + "] but was [" + value.getIntValue() + ": " + actualQuery + "], expected: " + expected + ", was: " + actual));
        }
        if (!Objects.equal((Object)value.getStringValue1(), (Object)expected.getOutput())) {
            throw new AssertionError((Object)("Expected sql with output [" + expected.getOutput() + "] but was [" + value.getStringValue1() + "], expected: " + expected + ", was: " + actual));
        }
        if (!Objects.equal((Object)value.getStringValue2(), (Object)expected.getBindValuesAsString())) {
            throw new AssertionError((Object)("Expected sql with bindValues [" + expected.getBindValuesAsString() + "] but was [" + value.getStringValue2() + "], expected: " + expected + ", was: " + actual));
        }
    }

    private int findApiId(Member method) throws AssertionError {
        String desc = this.getMemberInfo(method);
        return this.findApiId(desc);
    }

    private String getMemberInfo(Member method) {
        if (method instanceof Method) {
            return this.getMethodInfo((Method)method);
        }
        if (method instanceof Constructor) {
            return this.getConstructorInfo((Constructor)method);
        }
        throw new IllegalArgumentException("method: " + method);
    }

    private String getMethodInfo(Method method) {
        Class[] parameterTypes = method.getParameterTypes();
        String[] parameterTypeNames = JavaAssistUtils.toPinpointParameterType((Class[])parameterTypes);
        return MethodDescriptionUtils.toJavaMethodDescriptor(method.getDeclaringClass().getName(), method.getName(), parameterTypeNames);
    }

    private String getConstructorInfo(Constructor<?> constructor) {
        Class[] parameterTypes = constructor.getParameterTypes();
        String[] parameterTypeNames = JavaAssistUtils.toPinpointParameterType((Class[])parameterTypes);
        String constructorSimpleName = MethodDescriptionUtils.getConstructorSimpleName(constructor);
        return MethodDescriptionUtils.toJavaMethodDescriptor(constructor.getDeclaringClass().getName(), constructorSimpleName, parameterTypeNames);
    }

    private int findApiId(String desc) throws AssertionError {
        try {
            return this.getTestTcpDataSender().getApiId(desc);
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)("Cannot find apiId of [" + desc + "]"));
        }
    }

    private TestTcpDataSender getTestTcpDataSender() {
        TypeLiteral<EnhancedDataSender<Object>> dataSenderTypeLiteral;
        Key dataSenderKey;
        Injector injector = this.getInjector();
        EnhancedDataSender dataSender = (EnhancedDataSender)injector.getInstance(dataSenderKey = Key.get((TypeLiteral)(dataSenderTypeLiteral = new TypeLiteral<EnhancedDataSender<Object>>(){})));
        if (dataSender instanceof TestTcpDataSender) {
            return (TestTcpDataSender)dataSender;
        }
        throw new IllegalStateException("unexpected dataSender" + dataSender);
    }

    private OrderedSpanRecorder getRecorder() {
        ListenableDataSender listenableDataSender;
        ListenableDataSender.Listener listener;
        Key dataSenderKey;
        Injector injector = this.getInjector();
        DataSender dataSender = (DataSender)injector.getInstance(dataSenderKey = Key.get(DataSender.class, SpanDataSender.class));
        if (dataSender instanceof ListenableDataSender && (listener = (listenableDataSender = (ListenableDataSender)dataSender).getListener()) instanceof OrderedSpanRecorder) {
            return (OrderedSpanRecorder)listener;
        }
        throw new IllegalStateException("unexpected datasender:" + dataSender);
    }

    private ServerMetaData getServerMetaData() {
        Injector injector = this.getInjector();
        return ((ServerMetaDataRegistryService)injector.getInstance(ServerMetaDataRegistryService.class)).getServerMetaData();
    }

    private Item popItem() {
        Item item;
        do {
            OrderedSpanRecorder recorder;
            if ((item = (recorder = this.getRecorder()).popItem()) != null) continue;
            return null;
        } while (this.isIgnored(item.getValue()));
        return item;
    }

    public void printCache(PrintStream out) {
        this.getRecorder().print(out);
        this.getTestTcpDataSender().printDatas(out);
    }

    public void printCache() {
        this.printCache(System.out);
    }

    public void initialize(boolean createTraceObject) {
        if (createTraceObject) {
            TraceContext traceContext = this.getTraceContext();
            traceContext.newTraceObject();
        }
        this.getRecorder().clear();
        this.getTestTcpDataSender().clear();
        this.ignoredServiceTypes.clear();
    }

    public void cleanUp(boolean detachTraceObject) {
        if (detachTraceObject) {
            TraceContext traceContext = this.getTraceContext();
            traceContext.removeTraceObject();
        }
        this.getRecorder().clear();
        this.getTestTcpDataSender().clear();
        this.ignoredServiceTypes.clear();
    }

    private TraceContext getTraceContext() {
        DefaultApplicationContext applicationContext = this.getApplicationContext();
        return applicationContext.getTraceContext();
    }

    public void verifyIsLoggingTransactionInfo(LoggingInfo loggingInfo) {
        Item item = this.popItem();
        if (item == null) {
            throw new AssertionError((Object)("Expected a Span isLoggingTransactionInfo value with [" + loggingInfo.getName() + "]" + " but loggingTransactionInfo value invalid."));
        }
        TraceRoot traceRoot = item.getTraceRoot();
        byte loggingTransactionInfo = traceRoot.getShared().getLoggingInfo();
        if (loggingTransactionInfo != loggingInfo.getCode()) {
            LoggingInfo code = LoggingInfo.searchByCode((byte)loggingTransactionInfo);
            if (code != null) {
                throw new AssertionError((Object)("Expected a Span isLoggingTransactionInfo value with [" + loggingInfo.getName() + "]" + " but was [" + code.getName() + "]. expected: " + loggingInfo.getName() + ", was: " + code.getName()));
            }
            throw new AssertionError((Object)("Expected a Span isLoggingTransactionInfo value with [" + loggingInfo.getName() + "]" + " but loggingTransactionInfo value invalid."));
        }
    }

    private static final class ResolvedExpectedTrace {
        private final Class<?> type;
        private final ServiceType serviceType;
        private final LocalAsyncId localAsyncId;
        private final Integer apiId;
        private final Exception exception;
        private final ExpectedTraceField rpc;
        private final ExpectedTraceField endPoint;
        private final ExpectedTraceField remoteAddr;
        private final ExpectedTraceField destinationId;
        private final ExpectedAnnotation[] annotations;

        public ResolvedExpectedTrace(Class<?> type, ServiceType serviceType, Integer apiId, Exception exception, ExpectedTraceField rpc, ExpectedTraceField endPoint, ExpectedTraceField remoteAddr, ExpectedTraceField destinationId, ExpectedAnnotation[] annotations, Integer asyncId) {
            this.type = type;
            this.serviceType = serviceType;
            this.apiId = apiId;
            this.exception = exception;
            this.rpc = rpc;
            this.endPoint = endPoint;
            this.remoteAddr = remoteAddr;
            this.destinationId = destinationId;
            this.annotations = annotations;
            this.localAsyncId = this.newLocalAsyncId(asyncId);
        }

        private LocalAsyncId newLocalAsyncId(Integer asyncId) {
            if (asyncId == null) {
                return null;
            }
            return new DefaultLocalAsyncId(asyncId.intValue(), 0);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.type.getSimpleName());
            builder.append("(serviceType: ");
            builder.append(this.serviceType.getCode());
            builder.append(", apiId: ");
            builder.append(this.apiId);
            builder.append(", exception: ");
            builder.append(this.exception);
            builder.append(", rpc: ");
            builder.append(this.rpc);
            builder.append(", endPoint: ");
            builder.append(this.endPoint);
            builder.append(", remoteAddr: ");
            builder.append(this.remoteAddr);
            builder.append(", destinationId: ");
            builder.append(this.destinationId);
            builder.append(", annotations: ");
            builder.append(Arrays.deepToString(this.annotations));
            builder.append(", localAsyncId: ");
            builder.append(this.localAsyncId);
            builder.append(")");
            return builder.toString();
        }
    }

    private static final class SpanEventFacade
    implements ActualTrace {
        private final SpanEvent spanEvent;

        public SpanEventFacade(SpanEvent span) {
            this.spanEvent = span;
        }

        @Override
        public Short getServiceType() {
            return this.spanEvent.getServiceType();
        }

        @Override
        public Integer getApiId() {
            return this.spanEvent.getApiId();
        }

        @Override
        public Integer getAsyncId() {
            return this.spanEvent.getLocalAsyncId() != null ? Integer.valueOf(this.spanEvent.getLocalAsyncId().getAsyncId()) : null;
        }

        @Override
        public Integer getNextAsyncId() {
            return this.spanEvent.getAsyncIdObject() != null ? Integer.valueOf(this.spanEvent.getAsyncIdObject().getAsyncId()) : null;
        }

        @Override
        public IntStringValue getExceptionInfo() {
            return this.spanEvent.getExceptionInfo();
        }

        @Override
        public String getRpc() {
            return null;
        }

        @Override
        public String getEndPoint() {
            return this.spanEvent.getEndPoint();
        }

        @Override
        public String getRemoteAddr() {
            return null;
        }

        @Override
        public String getDestinationId() {
            return this.spanEvent.getDestinationId();
        }

        @Override
        public List<Annotation> getAnnotations() {
            return this.spanEvent.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return SpanEvent.class;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(serviceType: ");
            builder.append(this.getServiceType());
            builder.append(", apiId: ");
            builder.append(this.getApiId());
            builder.append(", exceptionInfo: ");
            builder.append(this.getExceptionInfo());
            builder.append(", rpc: ");
            builder.append(this.getRpc());
            builder.append(", endPoint: ");
            builder.append(this.getEndPoint());
            builder.append(", destinationId: ");
            builder.append(this.getDestinationId());
            builder.append(", [");
            PluginVerifierExternalAdaptor.appendAnnotations(builder, this.getAnnotations());
            builder.append("], asyncId: ");
            builder.append(this.getAsyncId());
            builder.append("nextAsyncId: ");
            builder.append(this.getNextAsyncId());
            builder.append(')');
            return builder.toString();
        }
    }

    private static final class SpanFacade
    implements ActualTrace {
        private final Span span;

        public SpanFacade(Span span) {
            this.span = span;
        }

        @Override
        public Short getServiceType() {
            short serviceType = this.span.getServiceType();
            if (serviceType == 0) {
                return null;
            }
            return serviceType;
        }

        @Override
        public Integer getApiId() {
            int apiId = this.span.getApiId();
            if (apiId == 0) {
                return null;
            }
            return apiId;
        }

        @Override
        public Integer getAsyncId() {
            return null;
        }

        @Override
        public Integer getNextAsyncId() {
            return null;
        }

        @Override
        public IntStringValue getExceptionInfo() {
            return this.span.getExceptionInfo();
        }

        @Override
        public String getRpc() {
            return this.span.getTraceRoot().getShared().getRpcName();
        }

        @Override
        public String getEndPoint() {
            return this.span.getTraceRoot().getShared().getEndPoint();
        }

        @Override
        public String getRemoteAddr() {
            return this.span.getRemoteAddr();
        }

        @Override
        public String getDestinationId() {
            return null;
        }

        @Override
        public List<Annotation> getAnnotations() {
            return this.span.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return Span.class;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(serviceType: ");
            builder.append(this.getServiceType());
            builder.append(", apiId: ");
            builder.append(this.getApiId());
            builder.append(", exceptionInfo: ");
            builder.append(this.getExceptionInfo());
            builder.append(", rpc: ");
            builder.append(this.getRpc());
            builder.append(", endPoint: ");
            builder.append(this.getEndPoint());
            builder.append(", remoteAddr: ");
            builder.append(this.getRemoteAddr());
            builder.append(", [");
            PluginVerifierExternalAdaptor.appendAnnotations(builder, this.getAnnotations());
            builder.append("])");
            return builder.toString();
        }
    }

    private static interface ActualTrace {
        public Short getServiceType();

        public Integer getApiId();

        public Integer getAsyncId();

        public Integer getNextAsyncId();

        public IntStringValue getExceptionInfo();

        public String getRpc();

        public String getEndPoint();

        public String getRemoteAddr();

        public String getDestinationId();

        public List<Annotation> getAnnotations();

        public Class<?> getType();
    }
}

