/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty;

import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class NettyUtils {
    public static String getEndPoint(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress remoteAddress = inetSocketAddress.getAddress();
            if (remoteAddress != null) {
                return HostAndPort.toHostAndPortString((String)remoteAddress.getHostAddress(), (int)inetSocketAddress.getPort());
            }
            String hostName = inetSocketAddress.getHostName();
            if (hostName != null) {
                return HostAndPort.toHostAndPortString((String)hostName, (int)inetSocketAddress.getPort());
            }
        }
        return "Unknown";
    }
}

