/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.SpanStatConnectTimer;
import com.navercorp.pinpoint.rpc.client.ClientChannelFactory;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class SpanStatChannelFactoryProvider
implements Provider<ChannelFactory> {
    private final ProfilerConfig profilerConfig;
    private final Provider<Timer> connectTimerProvider;

    @Inject
    public SpanStatChannelFactoryProvider(ProfilerConfig profilerConfig, @SpanStatConnectTimer Provider<Timer> connectTimerProvider) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.connectTimerProvider = (Provider)Assert.requireNonNull(connectTimerProvider, (String)"connectTimerProvider must not be null");
    }

    public ChannelFactory get() {
        int workerCount = 0;
        if ("TCP".equalsIgnoreCase(this.profilerConfig.getSpanDataSenderTransportType())) {
            ++workerCount;
        }
        if ("TCP".equalsIgnoreCase(this.profilerConfig.getStatDataSenderTransportType())) {
            ++workerCount;
        }
        if (workerCount == 0) {
            return null;
        }
        Timer timer = (Timer)this.connectTimerProvider.get();
        ClientChannelFactory clientChannelFactory = new ClientChannelFactory();
        return clientChannelFactory.createChannelFactory(1, workerCount, timer);
    }
}

