/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class TomcatConfig {
    private final boolean enable;
    private final List<String> bootstrapMains;
    private final boolean conditionalTransformEnable;
    private final boolean hidePinpointHeader;
    private final boolean traceRequestParam;
    private final Filter<String> excludeUrlFilter;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final Filter<String> excludeProfileMethodFilter;
    private final List<String> springBootBootstrapMains;

    public TomcatConfig(ProfilerConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.enable = config.readBoolean("profiler.tomcat.enable", true);
        this.bootstrapMains = config.readList("profiler.tomcat.bootstrap.main");
        this.conditionalTransformEnable = config.readBoolean("profiler.tomcat.conditional.transform", true);
        this.hidePinpointHeader = config.readBoolean("profiler.tomcat.hidepinpointheader", true);
        this.traceRequestParam = config.readBoolean("profiler.tomcat.tracerequestparam", true);
        String tomcatExcludeURL = config.readString("profiler.tomcat.excludeurl", "");
        this.excludeUrlFilter = !tomcatExcludeURL.isEmpty() ? new ExcludePathFilter(tomcatExcludeURL) : new SkipFilter();
        this.realIpHeader = config.readString("profiler.tomcat.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.tomcat.realipemptyvalue", null);
        String tomcatExcludeProfileMethod = config.readString("profiler.tomcat.excludemethod", "");
        this.excludeProfileMethodFilter = !tomcatExcludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(tomcatExcludeProfileMethod) : new SkipFilter();
        this.springBootBootstrapMains = config.readList("profiler.springboot.bootstrap.main");
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isConditionalTransformEnable() {
        return this.conditionalTransformEnable;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public List<String> getSpringBootBootstrapMains() {
        return this.springBootBootstrapMains;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TomcatConfig{");
        sb.append("enable=").append(this.enable);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", conditionalTransformEnable=").append(this.conditionalTransformEnable);
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append(", springBootBootstrapMains=").append(this.springBootBootstrapMains);
        sb.append('}');
        return sb.toString();
    }
}

