/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.aspect;

import com.navercorp.pinpoint.bootstrap.instrument.aspect.Aspect;
import com.navercorp.pinpoint.bootstrap.instrument.aspect.JointPoint;
import com.navercorp.pinpoint.bootstrap.instrument.aspect.PointCut;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;

@Aspect
public abstract class ChannelAspect {
    @PointCut
    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        AMQP.BasicProperties sourceProps = props;
        if (sourceProps == null) {
            sourceProps = MessageProperties.MINIMAL_BASIC;
        }
        AMQP.BasicProperties useProps = this.copy(sourceProps);
        this.__basicPublish(exchange, routingKey, mandatory, immediate, useProps, body);
    }

    private AMQP.BasicProperties copy(AMQP.BasicProperties source) {
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
        builder.contentType(source.getContentType());
        builder.contentEncoding(source.getContentEncoding());
        builder.headers(source.getHeaders());
        builder.deliveryMode(source.getDeliveryMode());
        builder.priority(source.getPriority());
        builder.correlationId(source.getCorrelationId());
        builder.replyTo(source.getReplyTo());
        builder.expiration(source.getExpiration());
        builder.messageId(source.getMessageId());
        builder.timestamp(source.getTimestamp());
        builder.type(source.getType());
        builder.userId(source.getUserId());
        builder.appId(source.getAppId());
        builder.clusterId(source.getClusterId());
        return builder.build();
    }

    @JointPoint
    abstract void __basicPublish(String var1, String var2, boolean var3, boolean var4, AMQP.BasicProperties var5, byte[] var6);
}

