/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.test.Item;
import com.navercorp.pinpoint.test.ListenableDataSender;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OrderedSpanRecorder
implements ListenableDataSender.Listener<Object>,
Iterable<Object> {
    public static final int ROOT_SEQUENCE = -1;
    public static final int ASYNC_ID_NOT_SET = -1;
    public static final int ASYNC_SEQUENCE_NOT_SET = -1;
    private final List<Item> list = new ArrayList<Item>();

    @Override
    public synchronized boolean handleSend(Object data) {
        if (data instanceof Span) {
            this.insertSpan((Span)data);
            return true;
        }
        if (data instanceof SpanChunk) {
            this.handleSpanEvent((SpanChunk)data);
            return true;
        }
        return false;
    }

    private void insertSpan(Span span) {
        long startTime = span.getStartTime();
        TraceRoot traceRoot = span.getTraceRoot();
        Item item = new Item(span, startTime, traceRoot, -1);
        this.insertItem(item);
    }

    private void insertItem(Item item) {
        int pos = Collections.binarySearch(this.list, item);
        if (pos >= 0) {
            throw new IllegalArgumentException("Duplicated?? list: " + this.list + ", item: " + item);
        }
        int index = -(pos + 1);
        this.list.add(index, item);
    }

    private void handleSpanEvent(SpanChunk spanChunk) {
        List spanEventList = spanChunk.getSpanEventList();
        for (SpanEvent event : spanEventList) {
            LocalAsyncId localAsyncId = event.getLocalAsyncId();
            int asyncId = -1;
            int asyncSequence = -1;
            if (localAsyncId != null) {
                asyncId = localAsyncId.getAsyncId();
                asyncSequence = localAsyncId.getSequence();
            }
            long startTime = event.getStartTime();
            Item item = new Item(event, startTime, spanChunk.getTraceRoot(), event.getSequence(), asyncId, asyncSequence);
            this.insertItem(item);
        }
    }

    public synchronized Object pop() {
        Item item = this.popItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public synchronized Item popItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.remove(0);
    }

    public synchronized void print(PrintStream out) {
        out.println("TRACES(" + this.list.size() + "):");
        for (Item item : this.list) {
            out.println(item);
        }
        for (Object obj : this) {
            out.println(obj);
        }
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized Iterator<Object> iterator() {
        return new RecorderIterator();
    }

    public String toString() {
        return "OrderedSpanRecorder{list=" + this.list + '}';
    }

    private final class RecorderIterator
    implements Iterator<Object> {
        private int current = -1;
        private int index = 0;

        private RecorderIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            OrderedSpanRecorder orderedSpanRecorder = OrderedSpanRecorder.this;
            synchronized (orderedSpanRecorder) {
                return this.index < OrderedSpanRecorder.this.list.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            OrderedSpanRecorder orderedSpanRecorder = OrderedSpanRecorder.this;
            synchronized (orderedSpanRecorder) {
                this.current = this.index++;
                Item item = (Item)OrderedSpanRecorder.this.list.get(this.current);
                return item.getValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            OrderedSpanRecorder orderedSpanRecorder = OrderedSpanRecorder.this;
            synchronized (orderedSpanRecorder) {
                if (this.current == -1) {
                    throw new IllegalStateException();
                }
                OrderedSpanRecorder.this.list.remove(this.current);
                this.current = -1;
                --this.index;
            }
        }
    }
}

