/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.common.util.LongIntIntByteByteStringValue;
import com.navercorp.pinpoint.common.util.StringStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;
import com.navercorp.pinpoint.thrift.dto.TIntBooleanIntBooleanValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringStringValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringValue;
import com.navercorp.pinpoint.thrift.dto.TLongIntIntByteByteStringValue;
import com.navercorp.pinpoint.thrift.dto.TStringStringValue;
import org.apache.thrift.TBase;

public final class AnnotationValueMapper {
    private AnnotationValueMapper() {
    }

    public static Object checkValueType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof IntStringValue) {
            return value;
        }
        if (value instanceof IntStringStringValue) {
            return value;
        }
        if (value instanceof LongIntIntByteByteStringValue) {
            return value;
        }
        if (value instanceof IntBooleanIntBooleanValue) {
            return value;
        }
        if (value instanceof StringStringValue) {
            return value;
        }
        if (value instanceof TBase) {
            throw new IllegalArgumentException("TBase not supported. Class:" + value.getClass());
        }
        String str = StringUtils.abbreviate((String)value.toString());
        return str;
    }

    public static TAnnotationValue buildTAnnotationValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return TAnnotationValue.stringValue((String)((String)value));
        }
        if (value instanceof Integer) {
            return TAnnotationValue.intValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return TAnnotationValue.longValue((long)((Long)value));
        }
        if (value instanceof Boolean) {
            return TAnnotationValue.boolValue((boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return TAnnotationValue.byteValue((byte)((Byte)value));
        }
        if (value instanceof Float) {
            return TAnnotationValue.doubleValue((double)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return TAnnotationValue.doubleValue((double)((Double)value));
        }
        if (value instanceof byte[]) {
            return TAnnotationValue.binaryValue((byte[])((byte[])value));
        }
        if (value instanceof Short) {
            return TAnnotationValue.shortValue((short)((Short)value));
        }
        if (value instanceof IntStringValue) {
            IntStringValue v = (IntStringValue)value;
            TIntStringValue tIntStringValue = new TIntStringValue(v.getIntValue());
            if (v.getStringValue() != null) {
                tIntStringValue.setStringValue(v.getStringValue());
            }
            return TAnnotationValue.intStringValue((TIntStringValue)tIntStringValue);
        }
        if (value instanceof StringStringValue) {
            StringStringValue v = (StringStringValue)value;
            TStringStringValue tStringStringValue = new TStringStringValue(v.getStringValue1());
            if (v.getStringValue2() != null) {
                tStringStringValue.setStringValue2(v.getStringValue2());
            }
            return TAnnotationValue.stringStringValue((TStringStringValue)tStringStringValue);
        }
        if (value instanceof IntStringStringValue) {
            IntStringStringValue v = (IntStringStringValue)value;
            TIntStringStringValue tIntStringStringValue = new TIntStringStringValue(v.getIntValue());
            if (v.getStringValue1() != null) {
                tIntStringStringValue.setStringValue1(v.getStringValue1());
            }
            if (v.getStringValue2() != null) {
                tIntStringStringValue.setStringValue2(v.getStringValue2());
            }
            return TAnnotationValue.intStringStringValue((TIntStringStringValue)tIntStringStringValue);
        }
        if (value instanceof LongIntIntByteByteStringValue) {
            LongIntIntByteByteStringValue v = (LongIntIntByteByteStringValue)value;
            TLongIntIntByteByteStringValue tvalue = new TLongIntIntByteByteStringValue(v.getLongValue(), v.getIntValue1());
            if (v.getIntValue2() != -1) {
                tvalue.setIntValue2(v.getIntValue2());
            }
            if (v.getByteValue1() != -1) {
                tvalue.setByteValue1(v.getByteValue1());
            }
            if (v.getByteValue2() != -1) {
                tvalue.setByteValue2(v.getByteValue2());
            }
            if (v.getStringValue() != null) {
                tvalue.setStringValue(v.getStringValue());
            }
            return TAnnotationValue.longIntIntByteByteStringValue((TLongIntIntByteByteStringValue)tvalue);
        }
        if (value instanceof IntBooleanIntBooleanValue) {
            IntBooleanIntBooleanValue v = (IntBooleanIntBooleanValue)value;
            TIntBooleanIntBooleanValue tvalue = new TIntBooleanIntBooleanValue(v.getIntValue1(), v.isBooleanValue1(), v.getIntValue2(), v.isBooleanValue2());
            return TAnnotationValue.intBooleanIntBooleanValue((TIntBooleanIntBooleanValue)tvalue);
        }
        if (value instanceof TBase) {
            throw new IllegalArgumentException("TBase not supported. Class:" + value.getClass());
        }
        String str = StringUtils.abbreviate((String)value.toString());
        return TAnnotationValue.stringValue((String)str);
    }
}

