#!/bin/sh
echo "deploy node"
package_path="/home/quant_group/project"

echo "cd ${package_path}"
cd ${package_path}

echo "tar zxf dist.tgz  -C ${package_path}"
tar zxf ${package_path}/dist.tgz  -C ${package_path}/

echo "sed sed xyqb.com to q-gp.com"
namespace=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "namespace is $namespace"
find ${package_path}/ -type f -name "*.js" | xargs sed -i "s/.xyqb.com/-$namespace.q-gp.com/g"
find ${package_path}/ -type f -name "*.js" | xargs sed -i "s/.domain.com/-$namespace.q-gp.com/g"

sed -i "s/xterm.js demo/${SYSTEM_NAME}@${namespace}/"  /home/qg-xterm/demo/index.html

echo "rm dist.tgz public/dist -rf"
rm -rf ${package_path}/dist.tgz

echo "sh start.sh"
sh start.sh

echo "sleep 3"
sleep 3

if ls ./*log 1> /dev/null 2>&1; then
    echo "ls -l ./logs"
    ls -l ./logs    
else
    echo "files do not exist"
    touch ./logs/tmp.log
fi

echo "cd /home/qg-xterm/;git pull;cd -"
cd /home/qg-xterm/;git pull;cd -

echo "node /home/qg-xterm/demo/app.js"
nohup node /home/qg-xterm/demo/app.js &

echo "frontail logs/*.log -d -n 1000"
frontail ./logs/*log -n 1000