/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.lettuce;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.redis.lettuce.LettuceMethodNameFilter;
import com.navercorp.pinpoint.plugin.redis.lettuce.LettucePluginConfig;
import java.security.ProtectionDomain;

public class LettucePlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final LettuceMethodNameFilter lettuceMethodNameFilter = new LettuceMethodNameFilter();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        LettucePluginConfig config = new LettucePluginConfig(context.getConfig());
        if (!config.isEnable()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Disable LettucePlugin.");
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Enable LettucePlugin. version range=[5.0.0.RELEASE, 5.1.2.RELEASE]");
        }
        this.addRedisClient();
        this.addDefaultConnectionFuture();
        this.addStatefulRedisConnection();
        this.addRedisCommands(config);
    }

    private void addRedisClient() {
        this.transformTemplate.transform("io.lettuce.core.RedisClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor");
                InstrumentMethod constructor = target.getConstructor(new String[]{"io.lettuce.core.resource.ClientResources", "io.lettuce.core.RedisURI"});
                if (constructor != null) {
                    constructor.addInterceptor("com.navercorp.pinpoint.plugin.redis.lettuce.interceptor.RedisClientConstructorInterceptor");
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"connect", "connectAsync", "connectPubSub", "connectPubSubAsync", "connectSentinel", "connectSentinelAsync"}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.redis.lettuce.interceptor.AttachEndPointInterceptor", "redisLettuceScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addDefaultConnectionFuture() {
        this.transformTemplate.transform("io.lettuce.core.DefaultConnectionFuture", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor");
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"get", "join"}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.redis.lettuce.interceptor.AttachEndPointInterceptor", "redisLettuceScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addStatefulRedisConnection() {
        this.addStatefulRedisConnection("io.lettuce.core.StatefulRedisConnectionImpl");
        this.addStatefulRedisConnection("io.lettuce.core.pubsub.StatefulRedisPubSubConnectionImpl");
        this.addStatefulRedisConnection("io.lettuce.core.pubsub.StatefulRedisClusterPubSubConnectionImpl");
        this.addStatefulRedisConnection("io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnectionImpl");
        this.addStatefulRedisConnection("io.lettuce.core.sentinel.StatefulRedisSentinelConnectionImpl");
    }

    private void addStatefulRedisConnection(String className) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor");
                return target.toBytecode();
            }
        });
    }

    private void addRedisCommands(LettucePluginConfig config) {
        this.addAbstractRedisCommands("io.lettuce.core.AbstractRedisAsyncCommands", true, config);
        this.addAbstractRedisCommands("io.lettuce.core.RedisAsyncCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.cluster.RedisAdvancedClusterAsyncCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.cluster.RedisClusterPubSubAsyncCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.AbstractRedisReactiveCommands", true, config);
        this.addAbstractRedisCommands("io.lettuce.core.cluster.RedisAdvancedClusterReactiveCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.cluster.RedisClusterPubSubReactiveCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.RedisReactiveCommandsImpl", false, config);
        this.addAbstractRedisCommands("io.lettuce.core.sentinel.RedisSentinelReactiveCommandsImpl", false, config);
    }

    private void addAbstractRedisCommands(String className, final boolean getter, LettucePluginConfig config) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (getter) {
                    target.addGetter("com.navercorp.pinpoint.plugin.redis.lettuce.StatefulConnectionGetter", "connection");
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{LettucePlugin.this.lettuceMethodNameFilter, MethodFilters.modifierNot((int)4096)}))) {
                    try {
                        method.addScopedInterceptor("com.navercorp.pinpoint.plugin.redis.lettuce.interceptor.LettuceMethodInterceptor", "redisLettuceScope");
                    }
                    catch (Exception e) {
                        if (!LettucePlugin.this.logger.isWarnEnabled()) continue;
                        LettucePlugin.this.logger.warn("Unsupported method {}", (Object)method, (Object)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

