/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow.common.servlet.util;

import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpServletParameterExtractor
implements ParameterExtractor<HttpServletRequest> {
    public static final int PARAMETER_EACH_LIMIT = 64;
    public static final int PARAMETER_TOTAL_LIMIT = 512;
    private final int eachLimit;
    private final int totalLimit;

    public HttpServletParameterExtractor() {
        this(64, 512);
    }

    public HttpServletParameterExtractor(int eachLimit, int totalLimit) {
        this.eachLimit = eachLimit;
        this.totalLimit = totalLimit;
    }

    public String extractParameter(HttpServletRequest httpServletRequest) {
        Map parameterMap = httpServletRequest.getParameterMap();
        if (parameterMap.isEmpty()) {
            return null;
        }
        StringBuilder params = new StringBuilder(64);
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (params.length() != 0) {
                params.append('&');
            }
            if (params.length() > this.totalLimit) {
                params.append("...");
                return params.toString();
            }
            String key = (String)entry.getKey();
            if (!StringUtils.hasLength((String)key)) continue;
            params.append(StringUtils.abbreviate((String)key, (int)this.eachLimit));
            params.append('=');
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtils.hasLength((Object[])values)) continue;
            for (Object value : values) {
                if (value == null) continue;
                params.append(StringUtils.abbreviate((String)StringUtils.toString((Object)value), (int)this.eachLimit));
            }
        }
        return params.toString();
    }
}

