/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.plugin.redis.jedis.CommandContext;
import com.navercorp.pinpoint.plugin.redis.jedis.CommandContextFactory;
import com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor;
import com.navercorp.pinpoint.plugin.redis.jedis.JedisConstants;

public class JedisMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private InterceptorScope interceptorScope;
    private boolean io;

    public JedisMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope, boolean io) {
        super(traceContext, methodDescriptor);
        this.interceptorScope = interceptorScope;
        this.io = io;
    }

    public void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        if (invocation != null) {
            invocation.getOrCreateAttachment(CommandContextFactory.COMMAND_CONTEXT_FACTORY);
        }
    }

    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        InterceptorScopeInvocation invocation;
        Object attachment;
        String endPoint = null;
        if (target instanceof EndPointAccessor) {
            endPoint = ((EndPointAccessor)target)._$PINPOINT$_getEndPoint();
        }
        if ((attachment = this.getAttachment(invocation = this.interceptorScope.getCurrentInvocation())) instanceof CommandContext) {
            CommandContext commandContext = (CommandContext)attachment;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Check command context {}", (Object)commandContext);
            }
            this.recordIo(recorder, commandContext);
            invocation.removeAttachment();
        }
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordEndPoint(endPoint != null ? endPoint : "Unknown");
        recorder.recordDestinationId(JedisConstants.REDIS.getName());
        recorder.recordServiceType(JedisConstants.REDIS);
        recorder.recordException(throwable);
    }

    private void recordIo(SpanEventRecorder recorder, CommandContext callContext) {
        if (this.io) {
            IntBooleanIntBooleanValue value = new IntBooleanIntBooleanValue((int)callContext.getWriteElapsedTime(), callContext.isWriteFail(), (int)callContext.getReadElapsedTime(), callContext.isReadFail());
            recorder.recordAttribute(AnnotationKey.REDIS_IO, (Object)value);
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

