/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.deadlock;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetric;
import com.navercorp.pinpoint.profiler.util.ThreadDumpUtils;
import com.navercorp.pinpoint.thrift.dto.TDeadlock;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import java.util.HashSet;
import java.util.Set;

public class DefaultDeadlockMetricCollector
implements AgentStatMetricCollector<TDeadlock> {
    private Set<Long> prevDeadlockedThreadIdSet = new HashSet<Long>();
    private final DeadlockMetric deadlockMetric;

    public DefaultDeadlockMetricCollector(DeadlockMetric deadlockMetric) {
        if (deadlockMetric == null) {
            throw new NullPointerException("deadlockMetric must not be null");
        }
        this.deadlockMetric = deadlockMetric;
    }

    @Override
    public TDeadlock collect() {
        Set<Long> deadlockedThreadIdSet = this.deadlockMetric.deadlockedThreadsIdSet();
        if (CollectionUtils.isEmpty(deadlockedThreadIdSet)) {
            return null;
        }
        if (this.prevDeadlockedThreadIdSet.containsAll(deadlockedThreadIdSet)) {
            TDeadlock deadlock = new TDeadlock();
            deadlock.setDeadlockedThreadCount(deadlockedThreadIdSet.size());
            return deadlock;
        }
        TDeadlock deadlock = new TDeadlock();
        deadlock.setDeadlockedThreadCount(deadlockedThreadIdSet.size());
        for (Long deadlockedThreadId : deadlockedThreadIdSet) {
            TThreadDump tThreadDump = ThreadDumpUtils.createTThreadDump(deadlockedThreadId);
            deadlock.addToDeadlockedThreadList(tThreadDump);
            this.prevDeadlockedThreadIdSet = deadlockedThreadIdSet;
        }
        return deadlock;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDeadlockMetricCollector{");
        sb.append("prevDeadlockedThreadIdSet=").append(this.prevDeadlockedThreadIdSet);
        sb.append(", deadlockMetric=").append(this.deadlockMetric);
        sb.append('}');
        return sb.toString();
    }
}

