/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.okhttp.EndPointUtils;
import com.navercorp.pinpoint.plugin.okhttp.v2.HttpUrlGetter;
import com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.AbstractRequestBuilderBuildMethodInterceptor;
import com.squareup.okhttp.HttpUrl;

public class RequestBuilderBuildMethodInterceptor
extends AbstractRequestBuilderBuildMethodInterceptor {
    public RequestBuilderBuildMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        super(traceContext, methodDescriptor, interceptorScope);
    }

    @Override
    String toHost(Object target) {
        if (target instanceof HttpUrlGetter) {
            HttpUrl url = ((HttpUrlGetter)target)._$PINPOINT$_getHttpUrl();
            return this.getDestinationId(url);
        }
        return null;
    }

    private String getDestinationId(HttpUrl httpUrl) {
        if (httpUrl == null || httpUrl.host() == null) {
            return "UnknownHttpClient";
        }
        int port = EndPointUtils.getPort(httpUrl.port(), HttpUrl.defaultPort((String)httpUrl.scheme()));
        return HostAndPort.toHostAndPortString((String)httpUrl.host(), (int)port);
    }
}

