/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

import com.secnium.iast.thirdparty.org.apache.commons.cli.AlreadySelectedException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.AmbiguousOptionException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.CommandLine;
import com.secnium.iast.thirdparty.org.apache.commons.cli.CommandLineParser;
import com.secnium.iast.thirdparty.org.apache.commons.cli.MissingArgumentException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.MissingOptionException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Option;
import com.secnium.iast.thirdparty.org.apache.commons.cli.OptionGroup;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Options;
import com.secnium.iast.thirdparty.org.apache.commons.cli.ParseException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.UnrecognizedOptionException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Util;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;

    public CommandLine parse(Options options, String[] stringArray) throws ParseException {
        return this.parse(options, stringArray, null);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties) throws ParseException {
        return this.parse(options, stringArray, properties, false);
    }

    public CommandLine parse(Options options, String[] stringArray, boolean bl) throws ParseException {
        return this.parse(options, stringArray, null, bl);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties, boolean bl) throws ParseException {
        this.options = options;
        this.stopAtNonOption = bl;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(options.getRequiredOptions());
        for (OptionGroup optionGroup : options.getOptionGroups()) {
            optionGroup.setSelected(null);
        }
        this.cmd = new CommandLine();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.handleToken(string);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    private void handleProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            String string = enumeration.nextElement().toString();
            Option option = this.options.getOption(string);
            if (option == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", string);
            }
            OptionGroup optionGroup = this.options.getOptionGroup(option);
            boolean bl2 = bl = optionGroup != null && optionGroup.getSelected() != null;
            if (this.cmd.hasOption(string) || bl) continue;
            String string2 = properties.getProperty(string);
            if (option.hasArg()) {
                if (option.getValues() == null || option.getValues().length == 0) {
                    option.addValueForProcessing(string2);
                }
            } else if (!"yes".equalsIgnoreCase(string2) && !"true".equalsIgnoreCase(string2) && !"1".equalsIgnoreCase(string2)) continue;
            this.handleOption(option);
            this.currentOption = null;
        }
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            throw new MissingArgumentException(this.currentOption);
        }
    }

    private void handleToken(String string) throws ParseException {
        this.currentToken = string;
        if (this.skipParsing) {
            this.cmd.addArg(string);
        } else if ("--".equals(string)) {
            this.skipParsing = true;
        } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(string)) {
            this.currentOption.addValueForProcessing(Util.stripLeadingAndTrailingQuotes(string));
        } else if (string.startsWith("--")) {
            this.handleLongOption(string);
        } else if (string.startsWith("-") && !"-".equals(string)) {
            this.handleShortAndLongOption(string);
        } else {
            this.handleUnknownToken(string);
        }
        if (this.currentOption != null && !this.currentOption.acceptsArg()) {
            this.currentOption = null;
        }
    }

    private boolean isArgument(String string) {
        return !this.isOption(string) || this.isNegativeNumber(string);
    }

    private boolean isNegativeNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isOption(String string) {
        return this.isLongOption(string) || this.isShortOption(string);
    }

    private boolean isShortOption(String string) {
        String string2;
        if (!string.startsWith("-") || string.length() == 1) {
            return false;
        }
        int n = string.indexOf("=");
        String string3 = string2 = n == -1 ? string.substring(1) : string.substring(1, n);
        if (this.options.hasShortOption(string2)) {
            return true;
        }
        return string2.length() > 0 && this.options.hasShortOption(String.valueOf(string2.charAt(0)));
    }

    private boolean isLongOption(String string) {
        String string2;
        if (!string.startsWith("-") || string.length() == 1) {
            return false;
        }
        int n = string.indexOf("=");
        String string3 = string2 = n == -1 ? string : string.substring(0, n);
        if (!this.options.getMatchingOptions(string2).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(string) != null && !string.startsWith("--");
    }

    private void handleUnknownToken(String string) throws ParseException {
        if (string.startsWith("-") && string.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + string, string);
        }
        this.cmd.addArg(string);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private void handleLongOption(String string) throws ParseException {
        if (string.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(string);
        } else {
            this.handleLongOptionWithEqual(string);
        }
    }

    private void handleLongOptionWithoutEqual(String string) throws ParseException {
        List<String> list = this.options.getMatchingOptions(string);
        if (list.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (list.size() > 1) {
                throw new AmbiguousOptionException(string, list);
            }
            this.handleOption(this.options.getOption(list.get(0)));
        }
    }

    private void handleLongOptionWithEqual(String string) throws ParseException {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        List<String> list = this.options.getMatchingOptions(string3);
        if (list.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (list.size() > 1) {
                throw new AmbiguousOptionException(string3, list);
            }
            Option option = this.options.getOption(list.get(0));
            if (option.acceptsArg()) {
                this.handleOption(option);
                this.currentOption.addValueForProcessing(string2);
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleShortAndLongOption(String string) throws ParseException {
        String string2 = Util.stripLeadingHyphens(string);
        int n = string2.indexOf(61);
        if (string2.length() == 1) {
            if (this.options.hasShortOption(string2)) {
                this.handleOption(this.options.getOption(string2));
            } else {
                this.handleUnknownToken(string);
            }
        } else if (n == -1) {
            if (this.options.hasShortOption(string2)) {
                this.handleOption(this.options.getOption(string2));
            } else if (!this.options.getMatchingOptions(string2).isEmpty()) {
                this.handleLongOptionWithoutEqual(string);
            } else {
                String string3 = this.getLongPrefix(string2);
                if (string3 != null && this.options.getOption(string3).acceptsArg()) {
                    this.handleOption(this.options.getOption(string3));
                    this.currentOption.addValueForProcessing(string2.substring(string3.length()));
                    this.currentOption = null;
                } else if (this.isJavaProperty(string2)) {
                    this.handleOption(this.options.getOption(string2.substring(0, 1)));
                    this.currentOption.addValueForProcessing(string2.substring(1));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(string);
                }
            }
        } else {
            String string4 = string2.substring(0, n);
            String string5 = string2.substring(n + 1);
            if (string4.length() == 1) {
                Option option = this.options.getOption(string4);
                if (option != null && option.acceptsArg()) {
                    this.handleOption(option);
                    this.currentOption.addValueForProcessing(string5);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(string);
                }
            } else if (this.isJavaProperty(string4)) {
                this.handleOption(this.options.getOption(string4.substring(0, 1)));
                this.currentOption.addValueForProcessing(string4.substring(1));
                this.currentOption.addValueForProcessing(string5);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(string);
            }
        }
    }

    private String getLongPrefix(String string) {
        String string2 = Util.stripLeadingHyphens(string);
        String string3 = null;
        for (int i = string2.length() - 2; i > 1; --i) {
            String string4 = string2.substring(0, i);
            if (!this.options.hasLongOption(string4)) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    private boolean isJavaProperty(String string) {
        String string2 = string.substring(0, 1);
        Option option = this.options.getOption(string2);
        return option != null && (option.getArgs() >= 2 || option.getArgs() == -2);
    }

    private void handleOption(Option option) throws ParseException {
        this.checkRequiredArgs();
        option = (Option)option.clone();
        this.updateRequiredOptions(option);
        this.cmd.addOption(option);
        this.currentOption = option.hasArg() ? option : null;
    }

    private void updateRequiredOptions(Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup optionGroup = this.options.getOptionGroup(option);
            if (optionGroup.isRequired()) {
                this.expectedOpts.remove(optionGroup);
            }
            optionGroup.setSelected(option);
        }
    }

    protected void handleConcatenatedOptions(String string) throws ParseException {
        for (int i = 1; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            if (this.options.hasOption(string2)) {
                this.handleOption(this.options.getOption(string2));
                if (this.currentOption == null || string.length() == i + 1) continue;
                this.currentOption.addValueForProcessing(string.substring(i + 1));
                break;
            }
            this.handleUnknownToken(this.stopAtNonOption && i > 1 ? string.substring(i) : string);
            break;
        }
    }
}

