/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertiesConfigurationLayout;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringEscapeUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    static final String COMMENT_CHARS = "#!";
    static final String DEFAULT_SEPARATOR = " = ";
    private static final IOFactory DEFAULT_IO_FACTORY = new DefaultIOFactory();
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ESCAPE = "\\";
    private static final String DOUBLE_ESC = "\\\\";
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private PropertiesConfigurationLayout layout;
    private volatile IOFactory ioFactory;
    private boolean includesAllowed = true;

    public PropertiesConfiguration() {
        this.layout = this.createLayout();
    }

    public PropertiesConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.getLayout();
    }

    public PropertiesConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String string) {
        include = string;
    }

    public void setIncludesAllowed(boolean bl) {
        this.includesAllowed = bl;
    }

    @Deprecated
    public boolean getIncludesAllowed() {
        return this.isIncludesAllowed();
    }

    public boolean isIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.getLayout().getHeaderComment();
    }

    public void setHeader(String string) {
        this.getLayout().setHeaderComment(string);
    }

    public String getFooter() {
        return this.getLayout().getFooterComment();
    }

    public void setFooter(String string) {
        this.getLayout().setFooterComment(string);
    }

    public String getEncoding() {
        String string = super.getEncoding();
        return string != null ? string : DEFAULT_ENCODING;
    }

    public synchronized PropertiesConfigurationLayout getLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
        return this.layout;
    }

    public synchronized void setLayout(PropertiesConfigurationLayout propertiesConfigurationLayout) {
        if (this.layout != null) {
            this.removeConfigurationListener(this.layout);
        }
        this.layout = propertiesConfigurationLayout == null ? this.createLayout() : propertiesConfigurationLayout;
    }

    protected PropertiesConfigurationLayout createLayout() {
        return new PropertiesConfigurationLayout(this);
    }

    public IOFactory getIOFactory() {
        return this.ioFactory != null ? this.ioFactory : DEFAULT_IO_FACTORY;
    }

    public void setIOFactory(IOFactory iOFactory) {
        if (iOFactory == null) {
            throw new IllegalArgumentException("IOFactory must not be null!");
        }
        this.ioFactory = iOFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Reader reader) throws ConfigurationException {
        boolean bl = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.getLayout().load(reader);
        }
        finally {
            this.setAutoSave(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer writer) throws ConfigurationException {
        this.enterNoReload();
        try {
            this.getLayout().save(writer);
        }
        finally {
            this.exitNoReload();
        }
    }

    public void setBasePath(String string) {
        super.setBasePath(string);
        this.setIncludesAllowed(StringUtils.isNotEmpty(string));
    }

    public Object clone() {
        PropertiesConfiguration propertiesConfiguration = (PropertiesConfiguration)super.clone();
        if (this.layout != null) {
            propertiesConfiguration.setLayout(new PropertiesConfigurationLayout(propertiesConfiguration, this.layout));
        }
        return propertiesConfiguration;
    }

    boolean propertyLoaded(String string, String string2) throws ConfigurationException {
        boolean bl;
        if (StringUtils.isNotEmpty(PropertiesConfiguration.getInclude()) && string.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
            if (this.isIncludesAllowed()) {
                String[] stringArray = !this.isDelimiterParsingDisabled() ? StringUtils.split(string2, this.getListDelimiter()) : new String[]{string2};
                for (String string3 : stringArray) {
                    this.loadIncludeFile(this.interpolate(string3.trim()));
                }
            }
            bl = false;
        } else {
            this.addProperty(string, string2);
            bl = true;
        }
        return bl;
    }

    static boolean isCommentLine(String string) {
        String string2 = string.trim();
        return string2.length() < 1 || COMMENT_CHARS.indexOf(string2.charAt(0)) >= 0;
    }

    private static int countTrailingBS(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n;
        }
        return n;
    }

    protected static String unescapeJava(String string, char c2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        StringBuilder stringBuilder2 = new StringBuilder(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (bl2) {
                stringBuilder2.append(c3);
                if (stringBuilder2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuilder2.toString(), 16);
                    stringBuilder.append((char)n2);
                    stringBuilder2.setLength(0);
                    bl2 = false;
                    bl = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ConfigurationRuntimeException("Unable to parse unicode value: " + stringBuilder2, numberFormatException);
                }
            }
            if (bl) {
                bl = false;
                if (c3 == '\\') {
                    stringBuilder.append('\\');
                    continue;
                }
                if (c3 == '\'') {
                    stringBuilder.append('\'');
                    continue;
                }
                if (c3 == '\"') {
                    stringBuilder.append('\"');
                    continue;
                }
                if (c3 == 'r') {
                    stringBuilder.append('\r');
                    continue;
                }
                if (c3 == 'f') {
                    stringBuilder.append('\f');
                    continue;
                }
                if (c3 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c3 == 'n') {
                    stringBuilder.append('\n');
                    continue;
                }
                if (c3 == 'b') {
                    stringBuilder.append('\b');
                    continue;
                }
                if (c3 == c2) {
                    stringBuilder.append('\\');
                    stringBuilder.append(c2);
                    continue;
                }
                if (c3 == 'u') {
                    bl2 = true;
                    continue;
                }
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c3);
        }
        if (bl) {
            stringBuilder.append('\\');
        }
        return stringBuilder.toString();
    }

    private void loadIncludeFile(String string) throws ConfigurationException {
        URL uRL;
        URL uRL2 = ConfigurationUtils.locate(this.getFileSystem(), this.getBasePath(), string);
        if (uRL2 == null && (uRL = this.getURL()) != null) {
            uRL2 = ConfigurationUtils.locate(this.getFileSystem(), uRL.toString(), string);
        }
        if (uRL2 == null) {
            throw new ConfigurationException("Cannot resolve include file " + string);
        }
        this.load(uRL2);
    }

    public static class DefaultIOFactory
    implements IOFactory {
        public PropertiesReader createPropertiesReader(Reader reader, char c2) {
            return new PropertiesReader(reader, c2);
        }

        public PropertiesWriter createPropertiesWriter(Writer writer, char c2) {
            return new PropertiesWriter(writer, c2);
        }
    }

    public static interface IOFactory {
        public PropertiesReader createPropertiesReader(Reader var1, char var2);

        public PropertiesWriter createPropertiesWriter(Writer var1, char var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesWriter
    extends FilterWriter {
        private static final int BUF_SIZE = 8;
        private char delimiter;
        private String currentSeparator;
        private String globalSeparator;
        private String lineSeparator;

        public PropertiesWriter(Writer writer, char c2) {
            super(writer);
            this.delimiter = c2;
        }

        public String getCurrentSeparator() {
            return this.currentSeparator;
        }

        public void setCurrentSeparator(String string) {
            this.currentSeparator = string;
        }

        public String getGlobalSeparator() {
            return this.globalSeparator;
        }

        public void setGlobalSeparator(String string) {
            this.globalSeparator = string;
        }

        public String getLineSeparator() {
            return this.lineSeparator != null ? this.lineSeparator : LINE_SEPARATOR;
        }

        public void setLineSeparator(String string) {
            this.lineSeparator = string;
        }

        public void writeProperty(String string, Object object) throws IOException {
            this.writeProperty(string, object, false);
        }

        public void writeProperty(String string, List<?> list) throws IOException {
            for (int i = 0; i < list.size(); ++i) {
                this.writeProperty(string, list.get(i));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeProperty(String string, Object object, boolean bl) throws IOException {
            String string2;
            if (object instanceof List) {
                List list = (List)object;
                if (!bl) {
                    this.writeProperty(string, list);
                    return;
                }
                string2 = this.makeSingleLineValue(list);
            } else {
                string2 = this.escapeValue(object, false);
            }
            this.write(this.escapeKey(string));
            this.write(this.fetchSeparator(string, object));
            this.write(string2);
            this.writeln(null);
        }

        public void writeComment(String string) throws IOException {
            this.writeln("# " + string);
        }

        private String escapeKey(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (ArrayUtils.contains(SEPARATORS, c2) || ArrayUtils.contains(WHITE_SPACE, c2)) {
                    stringBuilder.append('\\');
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }

        private String escapeValue(Object object, boolean bl) {
            String string = this.handleBackslashs(object, bl);
            if (this.delimiter != '\u0000') {
                string = StringUtils.replace(string, String.valueOf(this.delimiter), PropertiesConfiguration.ESCAPE + this.delimiter);
            }
            return string;
        }

        private String handleBackslashs(Object object, boolean bl) {
            String string = String.valueOf(object);
            if (bl && string.indexOf(PropertiesConfiguration.DOUBLE_ESC) >= 0) {
                char c2 = PropertiesConfiguration.ESCAPE.charAt(0);
                StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == c2 && i < string.length() - 1 && string.charAt(i + 1) == c2) {
                        stringBuilder.append(PropertiesConfiguration.DOUBLE_ESC).append(PropertiesConfiguration.DOUBLE_ESC);
                        ++i;
                        continue;
                    }
                    stringBuilder.append(string.charAt(i));
                }
                string = stringBuilder.toString();
            }
            return StringEscapeUtils.escapeJava(string);
        }

        private String makeSingleLineValue(List<?> list) {
            if (!list.isEmpty()) {
                Iterator<?> iterator = list.iterator();
                String string = this.escapeValue(iterator.next(), true);
                StringBuilder stringBuilder = new StringBuilder(string);
                while (iterator.hasNext()) {
                    if (string.endsWith(PropertiesConfiguration.ESCAPE) && PropertiesConfiguration.countTrailingBS(string) / 2 % 2 != 0) {
                        stringBuilder.append(PropertiesConfiguration.ESCAPE).append(PropertiesConfiguration.ESCAPE);
                    }
                    stringBuilder.append(this.delimiter);
                    string = this.escapeValue(iterator.next(), true);
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        public void writeln(String string) throws IOException {
            if (string != null) {
                this.write(string);
            }
            this.write(this.getLineSeparator());
        }

        protected String fetchSeparator(String string, Object object) {
            return this.getGlobalSeparator() != null ? this.getGlobalSeparator() : this.getCurrentSeparator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesReader
    extends LineNumberReader {
        private static final Pattern PROPERTY_PATTERN = Pattern.compile("(([\\S&&[^\\\\" + new String(PropertiesConfiguration.access$000()) + "]]|\\\\.)*)(\\s*(\\s+|[" + new String(PropertiesConfiguration.access$000()) + "])\\s*)(.*)");
        private static final int IDX_KEY = 1;
        private static final int IDX_VALUE = 5;
        private static final int IDX_SEPARATOR = 3;
        private List<String> commentLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;
        private String propertySeparator = " = ";
        private char delimiter;

        public PropertiesReader(Reader reader) {
            this(reader, AbstractConfiguration.getDefaultListDelimiter());
        }

        public PropertiesReader(Reader reader, char c2) {
            super(reader);
            this.delimiter = c2;
        }

        public String readProperty() throws IOException {
            String string;
            this.commentLines.clear();
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                if ((string = this.readLine()) == null) {
                    return null;
                }
                if (PropertiesConfiguration.isCommentLine(string)) {
                    this.commentLines.add(string);
                    continue;
                }
                if (!PropertiesReader.checkCombineLines(string = string.trim())) break;
                string = string.substring(0, string.length() - 1);
                stringBuilder.append(string);
            }
            stringBuilder.append(string);
            return stringBuilder.toString();
        }

        public boolean nextProperty() throws IOException {
            String string = this.readProperty();
            if (string == null) {
                return false;
            }
            this.parseProperty(string);
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertySeparator() {
            return this.propertySeparator;
        }

        protected void parseProperty(String string) {
            String[] stringArray = PropertiesReader.doParseProperty(string);
            this.initPropertyName(stringArray[0]);
            this.initPropertyValue(stringArray[1]);
            this.initPropertySeparator(stringArray[2]);
        }

        protected void initPropertyName(String string) {
            this.propertyName = StringEscapeUtils.unescapeJava(string);
        }

        protected void initPropertyValue(String string) {
            this.propertyValue = PropertiesConfiguration.unescapeJava(string, this.delimiter);
        }

        protected void initPropertySeparator(String string) {
            this.propertySeparator = string;
        }

        private static boolean checkCombineLines(String string) {
            return PropertiesConfiguration.countTrailingBS(string) % 2 != 0;
        }

        private static String[] doParseProperty(String string) {
            Matcher matcher = PROPERTY_PATTERN.matcher(string);
            String[] stringArray = new String[]{"", "", ""};
            if (matcher.matches()) {
                stringArray[0] = matcher.group(1).trim();
                stringArray[1] = matcher.group(5).trim();
                stringArray[2] = matcher.group(3);
            }
            return stringArray;
        }
    }
}

