/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.agent;

import com.secnium.iast.agent.Agent;
import com.secnium.iast.agent.IastProperties;
import com.secnium.iast.agent.manager.EngineManager;
import com.secnium.iast.agent.monitor.MonitorDaemonThread;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;

public class AgentLauncher {
    private static final String LAUNCH_MODE_AGENT = "agent";
    private static final String LAUNCH_MODE_ATTACH = "attach";
    private static String LAUNCH_MODE;

    public static void premain(String args, Instrumentation inst) {
        LAUNCH_MODE = LAUNCH_MODE_AGENT;
        try {
            Agent.appendToolsPath();
            AgentLauncher.install(inst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void agentmain(String featureString, Instrumentation inst) {
        if ("uninstall".equals(featureString)) {
            System.out.println("[cn.huoxian.dongtai.iast] Engine is about to be uninstalled");
            AgentLauncher.uninstall();
        } else {
            LAUNCH_MODE = LAUNCH_MODE_ATTACH;
            AgentLauncher.install(inst);
        }
    }

    public static synchronized void uninstall() {
        EngineManager engineManager = EngineManager.getInstance();
        engineManager.uninstall();
    }

    private static void install(Instrumentation inst) {
        IastProperties.getInstance();
        AgentLauncher.loadEngine(inst);
    }

    private static void loadEngine(Instrumentation inst) {
        EngineManager engineManager = EngineManager.getInstance(inst, LAUNCH_MODE, ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        Thread agentMonitorDaemonThead = new Thread(new MonitorDaemonThread(engineManager));
        agentMonitorDaemonThead.setDaemon(true);
        agentMonitorDaemonThead.setName("dongtai-agent-monitor");
        agentMonitorDaemonThead.start();
    }
}

