
# -------------------------------------------------------------------------------
# Filename:    init_db_data.sh
# Revision:    1.0
# Date:        2017/08
# Author:      dekun.dai
# Description: 执行目录下所有数据库脚本
# -------------------------------------------------------------------------------

# sql_file_folder=$WORK_PATH/sql_to_run
#
# echo "cd $sql_file_folder"
# cd $sql_file_folder
#
# for entry in ./*
# do
#     echo "run sql file: $entry"
#     mysql -uroot < $entry
# done
#!/bin/bash
export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

echo "start replace db domain"
DB_FILE=dump.sql
HOST=$DB_SERVICE_HOST
PORT='3306'
USER='qa'
PASSWORD='qatest'
HTTPS='true'

echo "HOST=$HOST
PORT=$PORT
USER=$USER
PASSWORD=$PASSWORD
HTTPS=$HTTPS
NAMESPACE=$NAMESPACE"

EXCLUDED_TABLES=(
clotho.JOB_EXECUTION_LOG
clotho.JOB_STATUS_TRACE_LOG
notify.JOB_EXECUTION_LOG
notify.JOB_STATUS_TRACE_LOG
xyqb.JOB_EXECUTION_LOG
xyqb.JOB_STATUS_TRACE_LOG
xyqb.channel
xyqb.t_phonenum
mall.jd_address
mall.jd_brand
mall.jd_product_sku_image
mall.jd_property
mall.jd_sku
mall.jd_sku_detail_image
mall.jd_sku_specs
mall.spu_image
mall.sale_product_detail
mall.product_nature_value_bak
mall.product_sku
mall.product_sku_image
mall.product_specification
mall.product_spu
)

IGNORED_TABLES_STRING=''
for TABLE in "${EXCLUDED_TABLES[@]}"
do :
   IGNORED_TABLES_STRING+=" --ignore-table=${TABLE}"
done

echo "mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases --no-create-info ${IGNORED_TABLES_STRING} >> ${DB_FILE}"
mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases ${IGNORED_TABLES_STRING} >> ${DB_FILE}
echo "sed file"
if [[ $HTTPS = true ]];then
	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-base\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g" ${DB_FILE}
else
	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-base\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g; s#\https#http#g" ${DB_FILE}
fi

echo "mysql dump file"
mysql --host=${HOST} --port=${PORT}  --user=${USER} --password=${PASSWORD} < ${DB_FILE}