/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.akka.http;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.common.util.Assert;
import java.util.List;

public class AkkaHttpConfig {
    private static final String KEY_ENABLE = "profiler.akka.http.enable";
    private static final String KEY_EXCLUDEURL = "profiler.akka.http.excludeurl";
    private static final String KEY_IP_HEADER = "profiler.akka.http.realipheader";
    private static final String KEY_EXCLUDE_HTTP_METHOD = "profiler.akka.http.excludemethod";
    static final String KEY_TRANSFORM_TARGET_NAME = "profiler.akka.http.transform.targetname";
    static final String KEY_TRANSFORM_PARAMETERS = "profiler.akka.http.transform.targetparameter";
    private static final boolean DEFAULT_ENABLE = false;
    private static final String DEFAULT_TRANSFORM_TARGET_NAME = "akka.http.scaladsl.server.directives.BasicDirectives.$anonfun$mapRequestContext$2";
    private final boolean enable;
    private final String realIpHeader;
    private final Filter<String> excludeUrlFilter;
    private final Filter<String> excludeHttpMethodFilter;
    private final String transformTargetName;
    private final List<String> transformParameters;

    public AkkaHttpConfig(ProfilerConfig config) {
        Assert.requireNonNull((Object)config, (String)"config must not be null");
        this.enable = config.readBoolean(KEY_ENABLE, false);
        this.realIpHeader = config.readString(KEY_IP_HEADER, null);
        String excludeUrl = config.readString(KEY_EXCLUDEURL, "");
        this.excludeUrlFilter = !excludeUrl.isEmpty() ? new ExcludePathFilter(excludeUrl) : new SkipFilter();
        String excludeHttpMethodType = config.readString(KEY_EXCLUDE_HTTP_METHOD, "");
        this.excludeHttpMethodFilter = !excludeHttpMethodType.isEmpty() ? new ExcludeMethodFilter(excludeHttpMethodType) : new SkipFilter();
        this.transformTargetName = config.readString(KEY_TRANSFORM_TARGET_NAME, DEFAULT_TRANSFORM_TARGET_NAME);
        this.transformParameters = config.readList(KEY_TRANSFORM_PARAMETERS);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public Filter<String> getExcludeHttpMethodFilter() {
        return this.excludeHttpMethodFilter;
    }

    public String getTransformTargetName() {
        return this.transformTargetName;
    }

    public List<String> getTransformTargetParameters() {
        return this.transformParameters;
    }
}

