/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaAssistUtils {
    private static final String EMPTY_ARRAY = "()";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String ARRAY = "[]";
    private static final Pattern PARAMETER_SIGNATURE_PATTERN = Pattern.compile("\\[*L[^;]+;|\\[*[ZBCSIFDJ]|[ZBCSIFDJ]");
    private static final Map<String, String> PRIMITIVE_JAVA_TO_JVM = JavaAssistUtils.createPrimitiveJavaToJvmMap();

    private static Map<String, String> createPrimitiveJavaToJvmMap() {
        HashMap<String, String> primitiveJavaToJvm = new HashMap<String, String>();
        primitiveJavaToJvm.put("byte", "B");
        primitiveJavaToJvm.put("char", "C");
        primitiveJavaToJvm.put("double", "D");
        primitiveJavaToJvm.put("float", "F");
        primitiveJavaToJvm.put("int", "I");
        primitiveJavaToJvm.put("long", "J");
        primitiveJavaToJvm.put("short", "S");
        primitiveJavaToJvm.put("void", "V");
        primitiveJavaToJvm.put("boolean", "Z");
        return primitiveJavaToJvm;
    }

    private JavaAssistUtils() {
    }

    public static String javaTypeToJvmSignature(String[] javaTypeArray, String returnType) {
        if (returnType == null) {
            throw new NullPointerException("returnType must not be null");
        }
        String parameterSignature = JavaAssistUtils.javaTypeToJvmSignature(javaTypeArray);
        StringBuilder sb = new StringBuilder(parameterSignature.length() + 8);
        sb.append(parameterSignature);
        sb.append(JavaAssistUtils.toJvmSignature(returnType));
        return sb.toString();
    }

    public static String javaTypeToJvmSignature(String[] javaTypeArray) {
        if (ArrayUtils.isEmpty((Object[])javaTypeArray)) {
            return EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        for (String javaType : javaTypeArray) {
            String jvmSignature = JavaAssistUtils.toJvmSignature(javaType);
            buffer.append(jvmSignature);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String toJvmSignature(String javaType) {
        if (javaType == null) {
            throw new NullPointerException("javaType must not be null");
        }
        if (javaType.isEmpty()) {
            throw new IllegalArgumentException("invalid javaType. \"\"");
        }
        int javaObjectArraySize = JavaAssistUtils.getJavaObjectArraySize(javaType);
        int javaArrayLength = javaObjectArraySize * 2;
        String pureJavaType = javaObjectArraySize != 0 ? javaType.substring(0, javaType.length() - javaArrayLength) : javaType;
        String signature = PRIMITIVE_JAVA_TO_JVM.get(pureJavaType);
        if (signature != null) {
            return JavaAssistUtils.appendJvmArray(signature, javaObjectArraySize);
        }
        return JavaAssistUtils.toJvmObject(javaObjectArraySize, pureJavaType);
    }

    private static String toJvmObject(int javaObjectArraySize, String pureJavaType) {
        StringBuilder buffer = new StringBuilder(pureJavaType.length() + javaObjectArraySize + 2);
        for (int i = 0; i < javaObjectArraySize; ++i) {
            buffer.append('[');
        }
        buffer.append('L');
        buffer.append(JavaAssistUtils.javaNameToJvmName(pureJavaType));
        buffer.append(';');
        return buffer.toString();
    }

    public static String javaNameToJvmName(String javaName) {
        if (javaName == null) {
            throw new NullPointerException("javaName must not be null");
        }
        return javaName.replace('.', '/');
    }

    public static String jvmNameToJavaName(String jvmName) {
        if (jvmName == null) {
            throw new NullPointerException("jvmName must not be null");
        }
        return jvmName.replace('/', '.');
    }

    public static String javaClassNameToJvmResourceName(String javaName) {
        if (javaName == null) {
            throw new NullPointerException("javaName must not be null");
        }
        return javaName.replace('.', '/').concat(".class");
    }

    public static List<String> jvmNameToJavaName(List<String> jvmNameArray) {
        if (jvmNameArray == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(jvmNameArray.size());
        for (String jvmName : jvmNameArray) {
            list.add(JavaAssistUtils.jvmNameToJavaName(jvmName));
        }
        return list;
    }

    private static String appendJvmArray(String signature, int javaObjectArraySize) {
        if (javaObjectArraySize == 0) {
            return signature;
        }
        StringBuilder sb = new StringBuilder(signature.length() + javaObjectArraySize);
        for (int i = 0; i < javaObjectArraySize; ++i) {
            sb.append('[');
        }
        sb.append(signature);
        return sb.toString();
    }

    static int getJavaObjectArraySize(String javaType) {
        if (javaType == null) {
            throw new NullPointerException("javaType must not be null");
        }
        if (javaType.isEmpty()) {
            return 0;
        }
        int endIndex = javaType.length() - 1;
        char checkEndArrayExist = javaType.charAt(endIndex);
        if (checkEndArrayExist != ']') {
            return 0;
        }
        int arraySize = 0;
        for (int i = endIndex; i > 0; i -= 2) {
            char arrayEnd = javaType.charAt(i);
            char arrayStart = javaType.charAt(i - 1);
            if (arrayStart == '[' && arrayEnd == ']') {
                ++arraySize;
                continue;
            }
            return arraySize;
        }
        return arraySize;
    }

    public static String[] parseParameterSignature(String signature) {
        if (signature == null) {
            throw new NullPointerException("signature must not be null");
        }
        List<String> parameterSignatureList = JavaAssistUtils.splitParameterSignature(signature);
        if (parameterSignatureList.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] objectType = new String[parameterSignatureList.size()];
        for (int i = 0; i < parameterSignatureList.size(); ++i) {
            String parameterSignature = parameterSignatureList.get(i);
            objectType[i] = JavaAssistUtils.byteCodeSignatureToObjectType(parameterSignature, 0);
        }
        return objectType;
    }

    public static String javaClassNameToObjectName(String javaClassName) {
        char scheme = javaClassName.charAt(0);
        switch (scheme) {
            case '[': {
                return JavaAssistUtils.toArrayType(javaClassName);
            }
        }
        return javaClassName;
    }

    public static String javaClassNameToVariableName(String javaClassName) {
        if (javaClassName == null) {
            throw new NullPointerException("java class name must not be null");
        }
        return javaClassName.replace('.', '_').replace('$', '_').replace('[', '_').replace(']', '_');
    }

    private static String byteCodeSignatureToObjectType(String signature, int startIndex) {
        char scheme = signature.charAt(startIndex);
        switch (scheme) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'L': {
                return JavaAssistUtils.toObjectType(signature, startIndex + 1);
            }
            case '[': {
                return JavaAssistUtils.toArrayType(signature);
            }
        }
        throw new IllegalArgumentException("invalid signature :" + signature);
    }

    private static String toArrayType(String description) {
        int arraySize = JavaAssistUtils.getArraySize(description);
        String objectType = JavaAssistUtils.byteCodeSignatureToObjectType(description, arraySize);
        return JavaAssistUtils.arrayType(objectType, arraySize);
    }

    private static String arrayType(String objectType, int arraySize) {
        int arrayStringLength = ARRAY.length() * arraySize;
        StringBuilder sb = new StringBuilder(objectType.length() + arrayStringLength);
        sb.append(objectType);
        for (int i = 0; i < arraySize; ++i) {
            sb.append(ARRAY);
        }
        return sb.toString();
    }

    private static int getArraySize(String description) {
        char c;
        if (StringUtils.isEmpty((String)description)) {
            return 0;
        }
        int arraySize = 0;
        for (int i = 0; i < description.length() && (c = description.charAt(i)) == '['; ++i) {
            ++arraySize;
        }
        return arraySize;
    }

    private static String toObjectType(String signature, int startIndex) {
        String assistClass = signature.substring(startIndex, signature.length() - 1);
        String objectName = JavaAssistUtils.jvmNameToJavaName(assistClass);
        if (objectName.isEmpty()) {
            throw new IllegalArgumentException("invalid signature. objectName not found :" + signature);
        }
        return objectName;
    }

    private static List<String> splitParameterSignature(String signature) {
        String parameterSignature = JavaAssistUtils.getParameterSignature(signature);
        if (parameterSignature.isEmpty()) {
            return Collections.emptyList();
        }
        Matcher matcher = PARAMETER_SIGNATURE_PATTERN.matcher(parameterSignature);
        ArrayList<String> parameterTypeList = new ArrayList<String>();
        while (matcher.find()) {
            parameterTypeList.add(matcher.group());
        }
        return parameterTypeList;
    }

    private static String getParameterSignature(String signature) {
        int start = signature.indexOf(40);
        if (start == -1) {
            throw new IllegalArgumentException("'(' not found. signature:" + signature);
        }
        int end = signature.indexOf(41, start + 1);
        if (end == -1) {
            throw new IllegalArgumentException("')' not found. signature:" + signature);
        }
        if (++start == end) {
            return "";
        }
        return signature.substring(start, end);
    }

    public static String[] getParameterType(Class[] paramsClass) {
        if (paramsClass == null) {
            return null;
        }
        String[] paramsString = new String[paramsClass.length];
        for (int i = 0; i < paramsClass.length; ++i) {
            paramsString[i] = paramsClass[i].getName();
        }
        return paramsString;
    }

    public static String[] toPinpointParameterType(Class<?>[] paramClasses) {
        if (paramClasses == null) {
            return null;
        }
        String[] paramsString = new String[paramClasses.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            paramsString[i] = JavaAssistUtils.toPinpointParameterType(paramClasses[i]);
        }
        return paramsString;
    }

    public static String toPinpointParameterType(Class<?> type) {
        if (type.isArray()) {
            return JavaAssistUtils.toPinpointParameterType(type.getComponentType()) + ARRAY;
        }
        return type.getName();
    }

    @Deprecated
    public static String getParameterDescription(Class[] params) {
        if (params == null) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append('(');
        int end = params.length - 1;
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i].getName());
            if (i >= end) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getParameterDescription(String[] params) {
        if (params == null) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append('(');
        int end = params.length - 1;
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
            if (i >= end) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }
}

