/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.profiler.instrument.transformer.LambdaClassFileResolver;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLambdaClassFileResolver
implements LambdaClassFileResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String resolve(ClassLoader classLoader, String classInternalName, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        if (classInternalName != null) {
            return classInternalName;
        }
        if (classFileBuffer == null) {
            return classInternalName;
        }
        try {
            ClassReader classReader = new ClassReader(classFileBuffer, 0, classFileBuffer.length);
            return classReader.getClassName();
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Failed to read metadata of lambda expressions. classLoader={}", (Object)classLoader, (Object)e);
            }
            return null;
        }
    }
}

