/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;

public class BootstrapPackage {
    private static final String[] BOOTSTRAP_PACKAGE_LIST = new String[]{"com.navercorp.pinpoint.bootstrap", "com.navercorp.pinpoint.common", "com.navercorp.pinpoint.exception"};
    private static final String[] INTERNAL_BOOTSTRAP_PACKAGE_LIST = BootstrapPackage.toInternalName(BOOTSTRAP_PACKAGE_LIST);

    private static String[] toInternalName(String[] bootstrapPackageList) {
        String[] internalPackageNames = new String[bootstrapPackageList.length];
        for (int i = 0; i < bootstrapPackageList.length; ++i) {
            String packageName = bootstrapPackageList[i];
            internalPackageNames[i] = JavaAssistUtils.javaNameToJvmName(packageName);
        }
        return internalPackageNames;
    }

    public boolean isBootstrapPackage(String className) {
        if (className == null) {
            return false;
        }
        for (String bootstrapPackage : BOOTSTRAP_PACKAGE_LIST) {
            if (!className.startsWith(bootstrapPackage)) continue;
            return true;
        }
        return false;
    }

    public boolean isBootstrapPackageByInternalName(String internalClassName) {
        if (internalClassName == null) {
            return false;
        }
        for (String bootstrapPackage : INTERNAL_BOOTSTRAP_PACKAGE_LIST) {
            if (!internalClassName.startsWith(bootstrapPackage)) continue;
            return true;
        }
        return false;
    }
}

