/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MetadataMessageConverter;
import org.apache.thrift.TBase;

public class MetadataMessageConverterProvider
implements Provider<MessageConverter<TBase<?, ?>>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;

    @Inject
    public MetadataMessageConverterProvider(@ApplicationName String applicationName, @AgentId String agentId, @AgentStartTime long agentStartTime) {
        this.applicationName = (String)Assert.requireNonNull((Object)applicationName, (String)"applicationName must not be null");
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTime = agentStartTime;
    }

    public MessageConverter<TBase<?, ?>> get() {
        MetadataMessageConverter messageConverter = new MetadataMessageConverter(this.applicationName, this.agentId, this.agentStartTime);
        return messageConverter;
    }
}

