/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.profiler.util.ApiUtils;
import java.util.Arrays;

public class DefaultMethodDescriptor
implements MethodDescriptor {
    private String className;
    private String methodName;
    private String[] parameterTypes;
    private String[] parameterVariableName;
    private String parameterDescriptor;
    private String apiDescriptor;
    private int lineNumber;
    private int apiId = 0;
    private String fullName;
    private int type = 0;

    public DefaultMethodDescriptor() {
    }

    public DefaultMethodDescriptor(String className, String methodName, String[] parameterTypes, String[] parameterVariableName) {
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameterVariableName = parameterVariableName;
        this.parameterDescriptor = ApiUtils.mergeParameterVariableNameDescription(parameterTypes, parameterVariableName);
        this.apiDescriptor = ApiUtils.mergeApiDescriptor(className, methodName, this.parameterDescriptor);
    }

    public String getParameterDescriptor() {
        return this.parameterDescriptor;
    }

    public void setParameterDescriptor(String parameterDescriptor) {
        this.parameterDescriptor = parameterDescriptor;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setParameterVariableName(String[] parameterVariableName) {
        this.parameterVariableName = parameterVariableName;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String[] getParameterVariableName() {
        return this.parameterVariableName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName;
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.className);
        buffer.append('.');
        buffer.append(this.methodName);
        buffer.append(this.parameterDescriptor);
        if (this.lineNumber != -1) {
            buffer.append(':');
            buffer.append(this.lineNumber);
        }
        this.fullName = buffer.toString();
        return this.fullName;
    }

    public void setApiDescriptor(String apiDescriptor) {
        this.apiDescriptor = apiDescriptor;
    }

    public String getApiDescriptor() {
        return this.apiDescriptor;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public int getApiId() {
        return this.apiId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{className=");
        builder.append(this.className);
        builder.append(", methodName=");
        builder.append(this.methodName);
        builder.append(", parameterTypes=");
        builder.append(Arrays.toString(this.parameterTypes));
        builder.append(", parameterVariableName=");
        builder.append(Arrays.toString(this.parameterVariableName));
        builder.append(", parameterDescriptor=");
        builder.append(this.parameterDescriptor);
        builder.append(", apiDescriptor=");
        builder.append(this.apiDescriptor);
        builder.append(", lineNumber=");
        builder.append(this.lineNumber);
        builder.append(", apiId=");
        builder.append(this.apiId);
        builder.append(", fullName=");
        builder.append(this.fullName);
        builder.append(", type=");
        builder.append(this.type);
        builder.append("}");
        return builder.toString();
    }
}

