/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandshaker;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.util.Timer;

public class HandshakerFactory {
    private static final int DEFAULT_ENABLE_WORKER_PACKET_RETRY_COUNT = Integer.MAX_VALUE;
    private int maxHandshakeCount = Integer.MAX_VALUE;
    private final AtomicInteger socketId;
    private final Map<String, Object> properties;
    private final ClusterOption clusterOption;
    private final ClientOption clientOption;

    public HandshakerFactory(AtomicInteger socketId, Map<String, Object> properties, ClientOption clientOption, ClusterOption clusterOption) {
        this.socketId = (AtomicInteger)Assert.requireNonNull((Object)socketId, (String)"socketId must not be null");
        this.clusterOption = (ClusterOption)Assert.requireNonNull((Object)clusterOption, (String)"clusterOption must not be null");
        this.clientOption = (ClientOption)Assert.requireNonNull((Object)clientOption, (String)"clientOption must not be null");
        this.properties = (Map)Assert.requireNonNull(properties, (String)"properties must not be null");
    }

    public PinpointClientHandshaker newHandShaker(Timer channelTimer) {
        Map<String, Object> handshakeData = this.createHandShakeData();
        return new PinpointClientHandshaker(handshakeData, channelTimer, this.clientOption.getEnableWorkerPacketDelay(), this.maxHandshakeCount);
    }

    private Map<String, Object> createHandShakeData() {
        HashMap<String, Object> handshakeData = new HashMap<String, Object>(this.properties);
        int socketId = this.nextSocketId();
        handshakeData.put("socketId", socketId);
        if (this.clusterOption.isEnable()) {
            handshakeData.put("cluster", this.clusterOption.toMap());
        }
        return handshakeData;
    }

    private int nextSocketId() {
        return this.socketId.getAndIncrement();
    }
}

